/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.app.SignatureBuild;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HeaderInfo;
import com.xdja.pki.itsca.oer.asn1.ItsAidInt;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.SequenceOfCertificate;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.SignedData;
import com.xdja.pki.itsca.oer.asn1.SignerInfo;
import com.xdja.pki.itsca.oer.asn1.TBSData;
import com.xdja.pki.itsca.oer.asn1.Time64;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.math.BigInteger;
import java.security.PrivateKey;
import org.bouncycastle.util.BigIntegers;

public class SecureMessageUtils {
    public static SecuredMessage buildSignSecuredMessage(Certificate signCert, HashAlgorithm hashAlgorithm, ItsAidInt aidInt, int privateKeyIndex, String privateKeyPassword, byte[] data) throws Exception {
        SignerInfo signerInfo;
        SecuredMessage securedMessage = new SecuredMessage();
        SignedData signedData = new SignedData();
        if (null == signCert) {
            signerInfo = new SignerInfo(new Null());
        } else {
            SequenceOfCertificate certs = new SequenceOfCertificate();
            certs.addCertificate(signCert);
            signerInfo = new SignerInfo(certs);
        }
        TBSData tbsData = new TBSData();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setItsAid(aidInt);
        headerInfo.setGenTime(new Time64(TimeUtils.getNowTime() * 1000L));
        headerInfo.setHashAlg(hashAlgorithm);
        tbsData.setHeaderInfo(headerInfo);
        tbsData.setData(data);
        byte[] signData = null == signCert ? SecureMessageUtils.buildSignData(tbsData.getEncode(), null, hashAlgorithm) : SecureMessageUtils.buildSignData(tbsData.getEncode(), signCert, hashAlgorithm);
        Signature signature = SignatureBuild.build((PrivateKey)new SdfPrivateKey(privateKeyIndex, privateKeyPassword.getBytes()), signData);
        signedData.setSignerInfo(signerInfo);
        signedData.setTbs(tbsData);
        signedData.setSign(signature);
        Payload payload = new Payload(signedData);
        securedMessage.setPayload(payload);
        return securedMessage;
    }

    private static byte[] buildSignData(byte[] data, Certificate signCert, HashAlgorithm hashAlgorithm) throws Exception {
        byte[] tbsHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])hashAlgorithm.getEncode(), (int)0, (int)1);
        if (choice.intValue() == HashAlgorithm.SGD_SM3.getIndex()) {
            if (null == signCert) {
                byte[] nullHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])"".getBytes());
                return ByteArrayUtils.buildUpByte(tbsHash, nullHash);
            }
            byte[] certHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])signCert.getEncode());
            return ByteArrayUtils.buildUpByte(tbsHash, certHash);
        }
        if (null == signCert) {
            byte[] nullHash = GMSSLSHA256DigestUtils.digestByYunHsm((byte[])"".getBytes());
            return ByteArrayUtils.buildUpByte(tbsHash, nullHash);
        }
        byte[] certHash = GMSSLSHA256DigestUtils.digestByYunHsm((byte[])signCert.getEncode());
        return ByteArrayUtils.buildUpByte(tbsHash, certHash);
    }
}

