/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.app.SignatureBuild;
import com.xdja.pki.itsca.oer.asn1.CertRequest;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HeaderInfo;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.SequenceOfCertificate;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.SignedData;
import com.xdja.pki.itsca.oer.asn1.SignerInfo;
import com.xdja.pki.itsca.oer.asn1.TBSData;
import com.xdja.pki.itsca.oer.asn1.Time64;
import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredMessageBuild {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public SecuredMessage build(PrivateKey privateKey, OERObject oerObject, int itsAidVaule, Certificate ... certificates) throws Exception {
        byte[] hash;
        SignerInfo signerInfo;
        SignedData signedData = new SignedData();
        if (oerObject instanceof CertRequest) {
            signerInfo = new SignerInfo(new Null());
            hash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])"".getBytes());
        } else if (oerObject instanceof SecuredMessage) {
            try {
                SequenceOfCertificate sequenceOfCertificate = new SequenceOfCertificate();
                sequenceOfCertificate.addCertificate(certificates[0]);
                signerInfo = new SignerInfo(sequenceOfCertificate);
                hash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])certificates[0].getEncode());
            }
            catch (Exception e) {
                signerInfo = new SignerInfo(new Null());
                hash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])"".getBytes());
            }
        } else {
            throw new Exception("can't support " + oerObject.getClass() + " type");
        }
        signedData.setSignerInfo(signerInfo);
        TBSData tbs = new TBSData();
        HeaderInfo headerInfo = new HeaderInfo();
        Int itsAid = new Int(itsAidVaule);
        headerInfo.setItsAid(itsAid);
        headerInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SGD_SM3));
        long nowTime = TimeUtils.getNowTime() * 1000L;
        Time64 genTime = new Time64(nowTime);
        headerInfo.setGenTime(genTime);
        tbs.setHeaderInfo(headerInfo);
        tbs.setData(oerObject.getEncode());
        signedData.setTbs(tbs);
        byte[] array = ByteArrayUtils.buildUpByte(GMSSLSM3DigestUtils.digestByYunhsm((byte[])tbs.getEncode()), hash);
        Signature signature = SignatureBuild.build(privateKey, array);
        signedData.setSign(signature);
        Payload payload = new Payload(signedData);
        SecuredMessage securedMessage = new SecuredMessage();
        securedMessage.setPayload(payload);
        return securedMessage;
    }
}

