/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.gmssl.core.utils.GMSSLBCAeadUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.itsca.oer.app.KekResolveUtils;
import com.xdja.pki.itsca.oer.app.SignatureBuild;
import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.app.data.KekBuilder;
import com.xdja.pki.itsca.oer.asn1.AesCcmCipherText;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.CipherText;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.EciesEncryptedKey;
import com.xdja.pki.itsca.oer.asn1.EncryptedData;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.HeaderInfo;
import com.xdja.pki.itsca.oer.asn1.ItsAidInt;
import com.xdja.pki.itsca.oer.asn1.PKRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.PreSharedKeyRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.PublicVerifyKey;
import com.xdja.pki.itsca.oer.asn1.RecipientInfo;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.SequenceOfCertificate;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.SignedData;
import com.xdja.pki.itsca.oer.asn1.SignerInfo;
import com.xdja.pki.itsca.oer.asn1.SymmetricCipherText;
import com.xdja.pki.itsca.oer.asn1.TBSData;
import com.xdja.pki.itsca.oer.asn1.Time64;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.cert.EccPointHolder;
import com.xdja.pki.itsca.oer.cert.bean.OEREccPoint;
import com.xdja.pki.itsca.oer.enums.EccCurveTypeEnum;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredMessageBuilder {
    private static Logger logger = LoggerFactory.getLogger(SecuredMessageBuilder.class);

    public static SecuredMessage buildSignedDataSecuredMessage(ItsAidInt itsAidInt, PrivateKey caPrivateKey, Certificate caCertificate, byte[] data) throws Exception {
        byte[] ecaHash;
        SecuredMessage sign = new SecuredMessage();
        SignedData signedData = new SignedData();
        SequenceOfCertificate sequenceOfCertificate = new SequenceOfCertificate();
        sequenceOfCertificate.addCertificate(caCertificate);
        SignerInfo signerInfo = new SignerInfo(sequenceOfCertificate);
        signedData.setSignerInfo(signerInfo);
        TBSData tbsData = new TBSData();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setItsAid(itsAidInt);
        tbsData.setHeaderInfo(headerInfo);
        tbsData.setData(data);
        signedData.setTbs(tbsData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] ecaEncode = caCertificate.getEncode();
        byte[] tbsDataEncode = tbsData.getEncode();
        PublicVerifyKey verifyKey = caCertificate.getTbsCert().getSubjectAttribute().getVerifyKey();
        OEREccPoint oerSignEccPoint = EccPointHolder.build(verifyKey.getEccPoint().getEncode(), verifyKey.getEccCurve());
        PublicKey publicKey = oerSignEccPoint.getPublicKey();
        Signature signature = null;
        if (((BCECPublicKey)publicKey).getParameters().getCurve() instanceof SM2P256V1Curve) {
            ecaHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])ecaEncode);
            byte[] tbsHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])tbsDataEncode);
            bos.write(tbsHash);
            bos.write(ecaHash);
            signature = SignatureBuild.build(caPrivateKey, bos.toByteArray(), EccCurveTypeEnum.SGD_SM2);
        } else {
            ecaHash = GMSSLSHA256DigestUtils.digestByBC((byte[])ecaEncode);
            byte[] tbsHash = GMSSLSHA256DigestUtils.digestByBC((byte[])tbsDataEncode);
            bos.write(tbsHash);
            bos.write(ecaHash);
            signature = SignatureBuild.build(caPrivateKey, bos.toByteArray(), EccCurveTypeEnum.NIST_P_256);
        }
        signedData.setSign(signature);
        Payload payload = new Payload(signedData);
        sign.setPayload(payload);
        return sign;
    }

    public static SecuredMessage buildSelfSignedDataSecuredMessage(ItsAidInt itsAidInt, PrivateKey privateKey, byte[] data, EccCurveTypeEnum eccCurveTypeEnum) throws Exception {
        SecuredMessage securedMessage = new SecuredMessage();
        SignedData signedData = new SignedData();
        SignerInfo signerInfo = new SignerInfo(new Null());
        TBSData tbsData = new TBSData();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setItsAid(itsAidInt);
        headerInfo.setGenTime(new Time64(TimeUtils.getNowTime() * 1000L));
        tbsData.setHeaderInfo(headerInfo);
        tbsData.setData(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] tbsDataEncode = tbsData.getEncode();
        byte[] nullHash = null;
        byte[] tbsHash = null;
        if (privateKey instanceof SdfPrivateKey) {
            if (eccCurveTypeEnum == EccCurveTypeEnum.SGD_SM2) {
                nullHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])"".getBytes());
                tbsHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])tbsDataEncode);
            } else if (eccCurveTypeEnum == EccCurveTypeEnum.NIST_P_256) {
                nullHash = GMSSLSHA256DigestUtils.digestByBC((byte[])"".getBytes());
                tbsHash = GMSSLSHA256DigestUtils.digestByBC((byte[])tbsDataEncode);
            }
        } else {
            BCECPrivateKey key = (BCECPrivateKey)privateKey;
            if (key.getParameters().getCurve() instanceof SM2P256V1Curve) {
                nullHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])"".getBytes());
                tbsHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])tbsDataEncode);
            } else {
                nullHash = GMSSLSHA256DigestUtils.digestByBC((byte[])"".getBytes());
                tbsHash = GMSSLSHA256DigestUtils.digestByBC((byte[])tbsDataEncode);
            }
        }
        bos.write(tbsHash);
        bos.write(nullHash);
        Signature signature = SignatureBuild.build(privateKey, bos.toByteArray(), eccCurveTypeEnum);
        signedData.setSignerInfo(signerInfo);
        signedData.setTbs(tbsData);
        signedData.setSign(signature);
        Payload payload = new Payload(signedData);
        securedMessage.setPayload(payload);
        return securedMessage;
    }

    public static SecuredMessage buildEncryptedDataSecuredMessage(Certificate caCertificate, byte[] data) throws Exception {
        return SecuredMessageBuilder.buildEncryptedDataSecuredMessage(caCertificate, data, EccCurveTypeEnum.SGD_SM2);
    }

    public static SecuredMessage buildEncryptedDataSecuredMessage(Certificate caCertificate, byte[] data, EccCurveTypeEnum eccCurveTypeEnum) throws Exception {
        EciesEncryptedKey kek;
        SecuredMessage enc = new SecuredMessage();
        byte[] key = GMSSLByteArrayUtils.base64Decode((String)com.xdja.pki.gmssl.crypto.utils.GMSSLRandomUtils.generateRandomByYunhsm((int)16));
        EncryptedData encryptedData = new EncryptedData();
        SequenceOfRecipientInfo sequenceOfRecipientInfo = new SequenceOfRecipientInfo();
        PKRecipientInfo certRecipInfo = new PKRecipientInfo();
        EccPoint publicKey = caCertificate.getTbsCert().getSubjectAttribute().getEncryptionKey().getPublicKey();
        RecipientInfo recipientInfo = new RecipientInfo(certRecipInfo, PKRecipientInfoType.CERT_RECIPINFO);
        sequenceOfRecipientInfo.addRecipientInfo(recipientInfo);
        encryptedData.setRecipients(sequenceOfRecipientInfo);
        SymmetricCipherText symmetricCipherText = null;
        byte[] certHash = null;
        if (eccCurveTypeEnum == EccCurveTypeEnum.SGD_SM2) {
            certHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])caCertificate.getEncode());
            kek = KekBuilder.build(publicKey, key, EccCurveTypeEnum.SGD_SM2);
            certRecipInfo.setKek(kek);
            certRecipInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SGD_SM3));
            CipherText cipherText = new CipherText();
            byte[] cipher = GMSSLSM4ECBEncryptUtils.sm4SymmetricWithPaddingByYunHsm((boolean)true, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, (byte[])key, (byte[])data);
            cipherText.setString(cipher);
            symmetricCipherText = new SymmetricCipherText(cipherText);
        } else if (eccCurveTypeEnum == EccCurveTypeEnum.NIST_P_256) {
            certHash = GMSSLSHA256DigestUtils.digestByYunHsm((byte[])caCertificate.getEncode());
            kek = KekBuilder.build(publicKey, key, EccCurveTypeEnum.NIST_P_256);
            certRecipInfo.setKek(kek);
            certRecipInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SHA_256));
            AesCcmCipherText ccmCipherText = new AesCcmCipherText();
            byte[] nonce = GMSSLRandomUtils.generateRandom((int)12);
            ccmCipherText.setNonce(nonce);
            byte[] cipher = GMSSLBCAeadUtils.encryptAESCCM((byte[])key, (int)16, (byte[])nonce, null, (byte[])data);
            CipherText cipherText = new CipherText();
            cipherText.setString(cipher);
            ccmCipherText.setCipher(cipherText);
            symmetricCipherText = new SymmetricCipherText(ccmCipherText);
        }
        byte[] certHashId8 = new byte[8];
        System.arraycopy(certHash, certHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        HashedId8 recipientId = new HashedId8(certHashId8);
        certRecipInfo.setRecipientId(recipientId);
        encryptedData.setCipherText(symmetricCipherText);
        Payload payload = new Payload(encryptedData);
        enc.setPayload(payload);
        logger.info("encrypt data secured message have finished");
        return enc;
    }

    public static SecuredMessage buildEncPskpiSecuredMessage(byte[] key, byte[] data, EccCurveTypeEnum eccCurveTypeEnum) throws Exception {
        SecuredMessage securedMessage = new SecuredMessage();
        EncryptedData encryptedData = new EncryptedData();
        SequenceOfRecipientInfo recipients = new SequenceOfRecipientInfo();
        PreSharedKeyRecipientInfo sharedKeyRecipientInfo = new PreSharedKeyRecipientInfo();
        RecipientInfo recipientInfo = new RecipientInfo(sharedKeyRecipientInfo);
        recipients.addRecipientInfo(recipientInfo);
        SymmetricCipherText symmetricCipherText = null;
        if (eccCurveTypeEnum == EccCurveTypeEnum.SGD_SM2) {
            sharedKeyRecipientInfo.setSmyKeyHash(new HashedId8(ByteArrayUtils.getHashId8(key)));
            sharedKeyRecipientInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SGD_SM3));
            String cipher = GMSSLSM4ECBEncryptUtils.encryptByYumhsmWithPKCS7Padding((String)Base64.toBase64String((byte[])key), (String)Base64.toBase64String((byte[])data));
            CipherText sm4Ecb = new CipherText();
            sm4Ecb.setString(Base64.decode((String)cipher));
            symmetricCipherText = new SymmetricCipherText(sm4Ecb);
        } else if (eccCurveTypeEnum == EccCurveTypeEnum.NIST_P_256) {
            byte[] keyHash = GMSSLSHA256DigestUtils.digestByYunHsm((byte[])key);
            byte[] keyBytes = new byte[8];
            System.arraycopy(keyHash, keyHash.length - 8, keyBytes, 0, keyBytes.length);
            sharedKeyRecipientInfo.setSmyKeyHash(new HashedId8(keyBytes));
            sharedKeyRecipientInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SHA_256));
            AesCcmCipherText ccmCipherText = new AesCcmCipherText();
            byte[] nonce = GMSSLRandomUtils.generateRandom((int)12);
            ccmCipherText.setNonce(nonce);
            byte[] cipher = GMSSLBCAeadUtils.encryptAESCCM((byte[])key, (int)16, (byte[])nonce, null, (byte[])data);
            CipherText cipherText = new CipherText();
            cipherText.setString(cipher);
            ccmCipherText.setCipher(cipherText);
            symmetricCipherText = new SymmetricCipherText(ccmCipherText);
        }
        encryptedData.setCipherText(symmetricCipherText);
        encryptedData.setRecipients(recipients);
        Payload payload = new Payload(encryptedData);
        securedMessage.setPayload(payload);
        return securedMessage;
    }

    public static byte[] resolveEncSecuredMessage(int privateKeyIndex, String privateKeyPassword, byte[] data) throws Exception {
        byte[] plain;
        SecuredMessage securedMessage = SecuredMessage.getInstance(data);
        EncryptedData encData = securedMessage.getPayload().getEncData();
        PKRecipientInfo pkRecipientInfo = encData.getRecipients().getRecipientInfos().get(0).getCertRecipInfo();
        if (null == pkRecipientInfo) {
            pkRecipientInfo = encData.getRecipients().getRecipientInfos().get(0).getSignedDataRecipInfo();
        }
        EciesEncryptedKey kek = pkRecipientInfo.getKek();
        byte[] key = KekResolveUtils.getPlain(kek, (PrivateKey)new SdfPrivateKey(privateKeyIndex, privateKeyPassword.getBytes()));
        SymmetricCipherText symmetricCipherText = encData.getCipherText();
        if (null != symmetricCipherText.getSm4Ecb()) {
            String decryptText = GMSSLSM4ECBEncryptUtils.decryptByYumhsmWithPKCS7Padding((String)Base64.toBase64String((byte[])key), (String)Base64.toBase64String((byte[])symmetricCipherText.getSm4Ecb().getString()));
            plain = Base64.decode((String)decryptText);
        } else {
            plain = GMSSLBCAeadUtils.decryptAESCCM((byte[])key, (int)16, (byte[])symmetricCipherText.getAesCcm().getNonce().getString(), null, (byte[])symmetricCipherText.getAesCcm().getCipher().getString());
        }
        return plain;
    }
}

