/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.enums.EccCurveTypeEnum;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import java.security.PrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Curve;

public class SignatureBuild {
    public static Signature build(PrivateKey privateKey, OERObject tobeSign) throws Exception {
        return SignatureBuild.build(privateKey, tobeSign.getEncode());
    }

    public static Signature build(PrivateKey privateKey, byte[] data) throws Exception {
        return SignatureBuild.build(privateKey, data, EccCurveTypeEnum.SGD_SM2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Signature build(PrivateKey privateKey, byte[] data, EccCurveTypeEnum eccCurveTypeEnum) throws Exception {
        byte[] s;
        byte[] r;
        EccCurve eccCurve;
        try {
            byte[] sign;
            if (privateKey instanceof SdfPrivateKey) {
                if (eccCurveTypeEnum == EccCurveTypeEnum.SGD_SM2) {
                    sign = GMSSLSM2SignUtils.signBySdfWithUserId((SdfCryptoType)SdfCryptoType.YUNHSM, (int)((SdfPrivateKey)privateKey).getIndex(), (String)new String(((SdfPrivateKey)privateKey).getPassword()), (byte[])"China".getBytes(), (byte[])data);
                    eccCurve = new EccCurve(EccCurve.SGD_SM2);
                } else {
                    if (eccCurveTypeEnum != EccCurveTypeEnum.NIST_P_256) throw new Exception("\u6682\u4e0d\u652f\u6301\u8be5\u66f2\u7ebf " + (Object)((Object)eccCurveTypeEnum));
                    sign = GMSSLECSignUtils.signByYunHsm((int)((SdfPrivateKey)privateKey).getIndex(), (String)new String(((SdfPrivateKey)privateKey).getPassword()), (byte[])data, (String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName());
                    eccCurve = new EccCurve(EccCurve.NIST_P_256);
                }
            } else {
                BCECPrivateKey key = (BCECPrivateKey)privateKey;
                if (key.getParameters().getCurve() instanceof SM2P256V1Curve) {
                    sign = BCUtils.sm2SignByBC(privateKey, data);
                    eccCurve = new EccCurve(EccCurve.SGD_SM2);
                } else {
                    if (!(key.getParameters().getCurve() instanceof SecP256R1Curve)) throw new Exception("\u6682\u4e0d\u652f\u6301\u8be5\u66f2\u7ebf\u7c7b\u578b " + key.getParameters().getCurve());
                    sign = GMSSLBCSignUtils.generateSignature((String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), (PrivateKey)privateKey, (byte[])data);
                    eccCurve = new EccCurve(EccCurve.NIST_P_256);
                }
            }
            byte[][] derDecode = BCUtils.sm2SignDerDecode(sign);
            assert (derDecode != null && derDecode.length == 2);
            r = derDecode[0];
            s = derDecode[1];
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        Signature signature = new Signature();
        signature.setEccCurve(eccCurve);
        signature.setR(r);
        signature.setS(s);
        return signature;
    }
}

