/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;

public class SignatureVerify {
    public static boolean verify(PublicKey publicKey, byte[] data, Signature signature) throws IOException {
        byte[] r = signature.getR().getxOnly().getString();
        byte[] s = signature.getS().getString();
        ByteArrayUtils.printHexBinary(null, "r", r);
        ByteArrayUtils.printHexBinary(null, "s", s);
        ByteArrayUtils.printHexBinary(null, "sign content", data);
        byte[] sign = BCUtils.sm2SignDerEncode(r, s);
        if (((BCECPublicKey)publicKey).getParameters().getCurve() instanceof SM2P256V1Curve) {
            try {
                return GMSSLSM2SignUtils.verifyBySdfWithUserId((SdfCryptoType)SdfCryptoType.YUNHSM, (PublicKey)publicKey, (byte[])"China".getBytes(), (byte[])data, (byte[])sign);
            }
            catch (Exception e) {
                return false;
            }
        }
        try {
            return GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), (PublicKey)publicKey, (byte[])data, (byte[])sign);
        }
        catch (Exception e) {
            return false;
        }
    }
}

