/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECIESEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.EciesEncryptedKey;
import com.xdja.pki.itsca.oer.asn1.Uncompressed;
import com.xdja.pki.itsca.oer.cert.EccPointHolder;
import com.xdja.pki.itsca.oer.enums.EccCurveTypeEnum;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.security.PublicKey;
import java.util.Objects;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Curve;

public class KekBuilder {
    public static EciesEncryptedKey build(EccPoint eccPoint, byte[] key) throws Exception {
        PublicKey publicKey = Objects.requireNonNull(EccPointHolder.build(eccPoint.getEncode())).getPublicKey();
        return KekBuilder.build(publicKey, key);
    }

    public static EciesEncryptedKey build(EccPoint eccPoint, byte[] key, EccCurveTypeEnum typeEnum) throws Exception {
        PublicKey publicKey = Objects.requireNonNull(EccPointHolder.build(eccPoint.getEncode(), typeEnum)).getPublicKey();
        return KekBuilder.build(publicKey, key);
    }

    public static EciesEncryptedKey build(PublicKey publicKey, byte[] key) throws Exception {
        ASN1SM2Cipher asn1SM2Cipher;
        byte[] cipher;
        EciesEncryptedKey kek = new EciesEncryptedKey();
        ECCurve eccCurve = ((BCECPublicKey)publicKey).getParameters().getCurve();
        if (eccCurve instanceof SM2P256V1Curve) {
            cipher = GMSSLSM2EncryptUtils.encryptASN1BySdf((SdfCryptoType)SdfCryptoType.YUNHSM, (PublicKey)publicKey, (byte[])key, (int)0, (int)key.length);
            asn1SM2Cipher = ASN1SM2Cipher.getInstance((Object)cipher);
            kek.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        } else if (eccCurve instanceof SecP256R1Curve) {
            cipher = GMSSLECIESEncryptUtils.encrypt((GMSSLCryptoType)GMSSLCryptoType.YUNHSM, (PublicKey)publicKey, (byte[])key);
            asn1SM2Cipher = ASN1SM2Cipher.convertToASN1((ECCurve)new SecP256R1Curve(), (byte[])cipher, (int)new SHA256Digest().getDigestSize());
            kek.setEccCurve(new EccCurve(EccCurve.NIST_P_256));
        } else {
            throw new Exception("\u4e0d\u652f\u6301\u7684\u66f2\u7ebf\u7c7b\u578b \uff1a " + eccCurve);
        }
        EccPoint v = new EccPoint();
        Uncompressed vu = new Uncompressed();
        vu.setX(ByteArrayUtils.changeByteArrayLength(asn1SM2Cipher.getxCoordinate()));
        vu.setY(ByteArrayUtils.changeByteArrayLength(asn1SM2Cipher.getyCoordinate()));
        v.setUncompressed(vu);
        kek.setV(v);
        kek.setC(asn1SM2Cipher.getCipherText());
        kek.setT(asn1SM2Cipher.getHash());
        return kek;
    }
}

