/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.ATSubjectAttributes;
import com.xdja.pki.itsca.oer.asn1.GeographicRegion;
import com.xdja.pki.itsca.oer.asn1.ValidityPeriod;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationValidationResponse
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(AuthorizationValidationResponse.class);
    private OctetString requestHash;
    private Int responseCode;
    private ATSubjectAttributes confirmedSubjectAttributes;
    private ValidityPeriod validityPeriod;
    private GeographicRegion region;

    public AuthorizationValidationResponse() {
        super(false, true);
    }

    public AuthorizationValidationResponse(byte[] requestHash, int responseCode, ATSubjectAttributes confirmedSubjectAttributes, ValidityPeriod validityPeriod, GeographicRegion region) {
        super(false, true);
        logger.info("AuthorizationValidationResponse new");
        this.setRequestHash(requestHash);
        logger.info("AuthorizationValidationResponse new start set code");
        this.setResponseCode(responseCode);
        logger.info("AuthorizationValidationResponse new done set code");
        this.confirmedSubjectAttributes = confirmedSubjectAttributes;
        this.validityPeriod = validityPeriod;
        this.region = region;
    }

    public static AuthorizationValidationResponse getInstance(byte[] data) throws Exception {
        AuthorizationValidationResponse response = new AuthorizationValidationResponse();
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        goal = new byte[32];
        System.arraycopy(data, 0, goal, 0, goal.length);
        OctetString requestHash = new OctetString();
        requestHash.setString(goal);
        requestHash.setLength(32);
        logger.info("getInstance  start set request hash");
        response.setRequestHash(requestHash);
        goal = new byte[data.length - 32];
        System.arraycopy(data, 32, goal, 0, goal.length);
        data = goal;
        response.setResponseCode((short)BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1).intValue());
        goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        ATSubjectAttributes attributes = ATSubjectAttributes.getInstance(data);
        response.setConfirmedSubjectAttributes(attributes);
        data = attributes.getGoal();
        ValidityPeriod validityPeriod = ValidityPeriod.getInstance(data);
        response.setValidityPeriod(validityPeriod);
        data = validityPeriod.getGoal();
        if (integers.contains(0)) {
            GeographicRegion geographicRegion = GeographicRegion.getInstance(data);
            response.setRegion(geographicRegion);
            data = geographicRegion.getGoal();
        }
        response.setGoal(data);
        return response;
    }

    public byte[] getRequestHash() {
        return this.requestHash.getString();
    }

    public void setRequestHash(byte[] requestHash) {
        this.requestHash = new OctetString(32);
        this.requestHash.setString(requestHash);
    }

    public ValidityPeriod getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(ValidityPeriod validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public Int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = new Int((byte)responseCode, 1);
    }

    public ATSubjectAttributes getConfirmedSubjectAttributes() {
        return this.confirmedSubjectAttributes;
    }

    public void setConfirmedSubjectAttributes(ATSubjectAttributes confirmedSubjectAttributes) {
        this.confirmedSubjectAttributes = confirmedSubjectAttributes;
    }

    public static void setLogger(Logger logger) {
        AuthorizationValidationResponse.logger = logger;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public void setResponseCode(Int responseCode) {
        this.responseCode = responseCode;
    }

    public GeographicRegion getRegion() {
        return this.region;
    }

    public void setRegion(GeographicRegion region) {
        this.region = region;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (this.region != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.requestHash);
        vector.add(this.responseCode);
        vector.add(this.confirmedSubjectAttributes);
        vector.add(this.validityPeriod);
        vector.add(this.region);
        return vector;
    }
}

