/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertRequest
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(CertRequest.class);
    private Time32 currentTime;
    private TbsCert tbsCertData;
    private PublicEncryptionKey encryptionKey;
    private OctetString itsId;

    public CertRequest() {
        super(false, true);
    }

    public static CertRequest getInstance(byte[] data) throws Exception {
        BigInteger optional = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        BitByte bitByte = BitByte.setBit(optional.intValue());
        byte[] goal = new byte[data.length - 1 - 1];
        System.arraycopy(data, 2, goal, 0, goal.length);
        data = goal;
        List<Integer> integers = bitByte.readIndexes();
        CertRequest certRequest = new CertRequest();
        BigInteger time = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)4);
        Time32 currentTime = new Time32(time.longValue());
        goal = new byte[data.length - 4];
        System.arraycopy(data, 4, goal, 0, goal.length);
        data = goal;
        certRequest.setCurrentTime(currentTime);
        TbsCert tbsCert = TbsCert.getInstance(data);
        data = tbsCert.getGoal();
        certRequest.setTbsCertData(tbsCert);
        if (integers.contains(0)) {
            PublicEncryptionKey encryptionKey = PublicEncryptionKey.getInstance(data);
            certRequest.setEncryptionKey(encryptionKey);
            data = encryptionKey.getGoal();
        }
        if (integers.contains(1)) {
            OctetString itsId = OctetString.getInstance(data);
            data = itsId.getGoal();
            certRequest.setItsId(itsId);
        }
        certRequest.setGoal(data);
        return certRequest;
    }

    public OctetString getItsId() {
        return this.itsId;
    }

    public void setItsId(OctetString itsId) {
        this.itsId = itsId;
    }

    public void setItsId(byte[] itsId) {
        this.itsId = new OctetString();
        this.itsId.setString(itsId);
    }

    public Time32 getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(Time32 currentTime) {
        this.currentTime = currentTime;
    }

    public TbsCert getTbsCertData() {
        return this.tbsCertData;
    }

    public void setTbsCertData(TbsCert tbsCertData) {
        this.tbsCertData = tbsCertData;
    }

    public PublicEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(PublicEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<Object> vector = new Vector<Object>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (null != this.encryptionKey) {
            optionals.add(7);
        }
        if (null != this.itsId) {
            optionals.add(6);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(2);
        vector.add(this.currentTime);
        vector.add(this.tbsCertData);
        vector.add(this.encryptionKey);
        vector.add(this.itsId);
        return vector;
    }
}

