/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.IssuerId;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Certificate
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(Certificate.class);
    private IssuerId issuerId;
    private TbsCert tbsCert;
    private Signature signature;
    private int version;

    public Certificate() {
        super(false, false);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public static Certificate getInstance(byte[] data) throws Exception {
        Certificate certificate = new Certificate();
        certificate.setVersion(BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1).intValue());
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        IssuerId issuerId = IssuerId.getInstance(data);
        data = issuerId.getGoal();
        TbsCert tbsCert = TbsCert.getInstance(data);
        data = tbsCert.getGoal();
        Signature signature = Signature.getInstance(data);
        data = signature.getGoal();
        certificate.setIssuerId(issuerId);
        certificate.setSignature(signature);
        certificate.setTbsCert(tbsCert);
        certificate.setGoal(data);
        return certificate;
    }

    public IssuerId getIssuerId() {
        return this.issuerId;
    }

    public void setIssuerId(IssuerId issuerId) {
        this.issuerId = issuerId;
    }

    public TbsCert getTbsCert() {
        return this.tbsCert;
    }

    public void setTbsCert(TbsCert tbsCert) {
        this.tbsCert = tbsCert;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(2);
        vector.add(this.issuerId);
        vector.add(this.tbsCert);
        vector.add(this.signature);
        return vector;
    }
}

