/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.SequenceOfRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.SymmetricCipherText;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedData
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(EncryptedData.class);
    private SequenceOfRecipientInfo recipients;
    private SymmetricCipherText cipherText;

    public EncryptedData() {
        super(false, false);
    }

    public static EncryptedData getInstance(byte[] data) throws Exception {
        EncryptedData encryptedData = new EncryptedData();
        SequenceOfRecipientInfo recipients = SequenceOfRecipientInfo.getInstance(data);
        encryptedData.setRecipients(recipients);
        data = recipients.getGoal();
        SymmetricCipherText cipherText = SymmetricCipherText.getInstance(data);
        encryptedData.setCipherText(cipherText);
        encryptedData.setGoal(cipherText.getGoal());
        return encryptedData;
    }

    public void setRecipients(SequenceOfRecipientInfo recipients) {
        this.recipients = recipients;
    }

    public void setCipherText(SymmetricCipherText cipherText) {
        this.cipherText = cipherText;
    }

    public SequenceOfRecipientInfo getRecipients() {
        return this.recipients;
    }

    public SymmetricCipherText getCipherText() {
        return this.cipherText;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.recipients);
        vector.add(this.cipherText);
        return vector;
    }
}

