/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId3;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.ThreeDLocation;
import com.xdja.pki.itsca.oer.asn1.Time64;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderInfo
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(HeaderInfo.class);
    private Int itsAid;
    private HashAlgorithm hashAlg;
    private Time64 genTime;
    private Time64 expiryTime;
    private ThreeDLocation location;
    private HashedId3 digest;
    private PublicEncryptionKey encKey;

    public HeaderInfo() {
        super(false, true);
    }

    public static HeaderInfo getInstance(byte[] data) throws Exception {
        BigInteger bigInteger = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        HeaderInfo headerInfo = new HeaderInfo();
        List<Integer> integers = BitByte.setBit(bigInteger.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        Int itsAid = Int.getInstance(data, new int[0]);
        headerInfo.setItsAid(itsAid);
        data = itsAid.getGoal();
        if (integers.contains(0)) {
            HashAlgorithm hashAlgorithm = HashAlgorithm.getInstance(data);
            headerInfo.setHashAlg(hashAlgorithm);
            data = hashAlgorithm.getGoal();
        }
        if (integers.contains(1)) {
            bigInteger = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)8);
            Time64 genTime = new Time64(bigInteger.longValue());
            headerInfo.setGenTime(genTime);
            goal = new byte[data.length - 8];
            System.arraycopy(data, 8, goal, 0, goal.length);
            data = goal;
        }
        if (integers.contains(2)) {
            bigInteger = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)8);
            Time64 expiryTime = new Time64(bigInteger.longValue());
            headerInfo.setExpiryTime(expiryTime);
            goal = new byte[data.length - 8];
            System.arraycopy(data, 8, goal, 0, goal.length);
            data = goal;
        }
        if (integers.contains(3)) {
            ThreeDLocation threeDLocation = ThreeDLocation.getInstance(data);
            headerInfo.setLocation(threeDLocation);
            data = threeDLocation.getGoal();
        }
        if (integers.contains(4)) {
            goal = new byte[3];
            System.arraycopy(data, 0, goal, 0, goal.length);
            HashedId3 hashedId3 = new HashedId3(goal);
            goal = new byte[data.length - 3];
            System.arraycopy(data, 3, goal, 0, goal.length);
            data = goal;
            headerInfo.setDigest(hashedId3);
        }
        if (integers.contains(5)) {
            PublicEncryptionKey publicEncryptionKey = PublicEncryptionKey.getInstance(data);
            headerInfo.setEncKey(publicEncryptionKey);
            data = publicEncryptionKey.getGoal();
        }
        headerInfo.setGoal(data);
        return headerInfo;
    }

    public Int getItsAid() {
        return this.itsAid;
    }

    public void setItsAid(Int itsAid) {
        this.itsAid = itsAid;
    }

    public HashAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    public void setHashAlg(HashAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public Time64 getGenTime() {
        return this.genTime;
    }

    public void setGenTime(Time64 genTime) {
        this.genTime = genTime;
    }

    public Time64 getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(Time64 expiryTime) {
        this.expiryTime = expiryTime;
    }

    public ThreeDLocation getLocation() {
        return this.location;
    }

    public void setLocation(ThreeDLocation location) {
        this.location = location;
    }

    public HashedId3 getDigest() {
        return this.digest;
    }

    public void setDigest(HashedId3 digest) {
        this.digest = digest;
    }

    public PublicEncryptionKey getEncKey() {
        return this.encKey;
    }

    public void setEncKey(PublicEncryptionKey encKey) {
        this.encKey = encKey;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (null != this.hashAlg) {
            optionals.add(7);
        }
        if (null != this.genTime) {
            optionals.add(6);
        }
        if (null != this.expiryTime) {
            optionals.add(5);
        }
        if (null != this.location) {
            optionals.add(4);
        }
        if (null != this.digest) {
            optionals.add(3);
        }
        if (null != this.encKey) {
            optionals.add(2);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.itsAid);
        vector.add(this.hashAlg);
        vector.add(this.genTime);
        vector.add(this.expiryTime);
        vector.add(this.location);
        vector.add(this.digest);
        vector.add(this.encKey);
        return vector;
    }
}

