/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.EcSignature;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.PublicVerifyKey;
import com.xdja.pki.itsca.oer.asn1.SharedATRequest;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerATRequest
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(InnerATRequest.class);
    private PublicVerifyKey verificationKey;
    private PublicEncryptionKey encryptionKey;
    private SharedATRequest sharedATRequest;
    private EcSignature ecSignature;

    public InnerATRequest() {
        super(false, true);
    }

    public static InnerATRequest getInstance(byte[] data) throws Exception {
        InnerATRequest innerATRequest = new InnerATRequest();
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        PublicVerifyKey verifyKey = PublicVerifyKey.getInstance(data);
        data = verifyKey.getGoal();
        innerATRequest.setVerificationKey(verifyKey);
        if (integers.contains(0)) {
            PublicEncryptionKey encryptionKey = PublicEncryptionKey.getInstance(data);
            data = encryptionKey.getGoal();
            innerATRequest.setEncryptionKey(encryptionKey);
        }
        SharedATRequest sharedATRequest = SharedATRequest.getInstance(data);
        data = sharedATRequest.getGoal();
        innerATRequest.setSharedATRequest(sharedATRequest);
        EcSignature ecSignature = EcSignature.getInstance(data);
        innerATRequest.setEcSignature(ecSignature);
        data = ecSignature.getGoal();
        innerATRequest.setGoal(data);
        return innerATRequest;
    }

    public PublicVerifyKey getVerificationKey() {
        return this.verificationKey;
    }

    public void setVerificationKey(PublicVerifyKey verificationKey) {
        this.verificationKey = verificationKey;
    }

    public PublicEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(PublicEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public SharedATRequest getSharedATRequest() {
        return this.sharedATRequest;
    }

    public void setSharedATRequest(SharedATRequest sharedATRequest) {
        this.sharedATRequest = sharedATRequest;
    }

    public EcSignature getEcSignature() {
        return this.ecSignature;
    }

    public void setEcSignature(EcSignature ecSignature) {
        this.ecSignature = ecSignature;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<Sequence> vector = new Vector<Sequence>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (this.encryptionKey != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.verificationKey);
        vector.add(this.encryptionKey);
        vector.add(this.sharedATRequest);
        vector.add(this.ecSignature);
        return vector;
    }
}

