/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Uint64;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItsAid
extends Uint64 {
    public static ItsAid SAFETY_FUNCTION_RESERVATION;
    public static ItsAid REGISTRATION_CERTIFICATE_REQUEST;
    public static ItsAid REGISTRATION_CERTIFICATE_RESPONSE;
    public static ItsAid NON_REGISTRATION_CERTIFICATE_REQUEST;
    public static ItsAid NON_REGISTRATION_CERTIFICATE_RESPONSE;
    public static ItsAid CRL;
    public static ItsAid KEY_AGREEMENT;
    public static ItsAid CERT_APPLY;
    public static ItsAid TRAFFIC_LIGHT_APPLICATION;
    private static final Logger logger;

    public static ItsAid getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)8);
        ItsAid itsAid = new ItsAid(integer.longValue());
        byte[] goal = new byte[data.length - 8];
        System.arraycopy(data, 8, goal, 0, goal.length);
        itsAid.setGoal(goal);
        return itsAid;
    }

    public ItsAid(long l) throws IOException {
        super(l);
    }

    public ItsAid(String aid) throws IOException {
        super(aid.length() % 2 == 1 ? Hex.decode((String)("0" + aid)) : Hex.decode((String)aid));
    }

    public ItsAid(byte[] aid) throws IOException {
        super(aid);
    }

    static {
        logger = LoggerFactory.getLogger((String)ItsAid.class.getName());
        try {
            SAFETY_FUNCTION_RESERVATION = new ItsAid(40960L);
            REGISTRATION_CERTIFICATE_REQUEST = new ItsAid(40961L);
            REGISTRATION_CERTIFICATE_RESPONSE = new ItsAid(40962L);
            NON_REGISTRATION_CERTIFICATE_REQUEST = new ItsAid(40963L);
            NON_REGISTRATION_CERTIFICATE_RESPONSE = new ItsAid(40964L);
            CRL = new ItsAid(41216L);
            KEY_AGREEMENT = new ItsAid(41472L);
            TRAFFIC_LIGHT_APPLICATION = new ItsAid(45057L);
            CERT_APPLY = new ItsAid(623L);
        }
        catch (IOException e) {
            logger.error("generate its aid error", (Throwable)e);
        }
    }
}

