/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreSharedKeyRecipientInfo
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(PreSharedKeyRecipientInfo.class);
    private HashAlgorithm hashAlg;
    private HashedId8 smyKeyHash;

    public HashAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    public void setHashAlg(HashAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public HashedId8 getSmyKeyHash() {
        return this.smyKeyHash;
    }

    public void setSmyKeyHash(HashedId8 smyKeyHash) {
        this.smyKeyHash = smyKeyHash;
    }

    public PreSharedKeyRecipientInfo() {
        super(false, false);
    }

    public static PreSharedKeyRecipientInfo getInstance(byte[] data) throws Exception {
        PreSharedKeyRecipientInfo preSharedKeyRecipientInfo = new PreSharedKeyRecipientInfo();
        HashAlgorithm hashAlgorithm = HashAlgorithm.getInstance(data);
        preSharedKeyRecipientInfo.setHashAlg(hashAlgorithm);
        data = hashAlgorithm.getGoal();
        byte[] goal = new byte[8];
        System.arraycopy(data, 0, goal, 0, goal.length);
        HashedId8 hashedId8 = new HashedId8(goal);
        goal = new byte[data.length - 8];
        System.arraycopy(data, 8, goal, 0, goal.length);
        preSharedKeyRecipientInfo.setSmyKeyHash(hashedId8);
        preSharedKeyRecipientInfo.setGoal(goal);
        return preSharedKeyRecipientInfo;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.hashAlg);
        vector.add(this.smyKeyHash);
        return vector;
    }
}

