/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.asn1.PKRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.PreSharedKeyRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.SymmRecipInfo;
import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientInfo
extends Choice {
    private static Logger logger = LoggerFactory.getLogger(RecipientInfo.class);
    private PreSharedKeyRecipientInfo pskRecipientInfo;
    private SymmRecipInfo symmRecipInfo;
    private PKRecipientInfo certRecipInfo;
    private PKRecipientInfo signedDataRecipInfo;

    public RecipientInfo(PreSharedKeyRecipientInfo pskRecipientInfo) {
        this.pskRecipientInfo = pskRecipientInfo;
        this.symmRecipInfo = null;
        this.certRecipInfo = null;
        this.signedDataRecipInfo = null;
    }

    public RecipientInfo(SymmRecipInfo symmRecipInfo) {
        this.addIndex(1);
        this.pskRecipientInfo = null;
        this.symmRecipInfo = symmRecipInfo;
        this.certRecipInfo = null;
        this.signedDataRecipInfo = null;
    }

    public RecipientInfo(PKRecipientInfo info, PKRecipientInfoType pkRecipientInfoType) {
        this.pskRecipientInfo = null;
        this.symmRecipInfo = null;
        this.certRecipInfo = null;
        this.signedDataRecipInfo = null;
        if (pkRecipientInfoType.id == PKRecipientInfoType.CERT_RECIPINFO.id) {
            this.addIndex(2);
            this.certRecipInfo = info;
        }
        if (pkRecipientInfoType.id == PKRecipientInfoType.SIGNEDDATA_RECIPINFO.id) {
            this.addIndex(3);
            this.signedDataRecipInfo = info;
        }
    }

    public static RecipientInfo getInstance(byte[] data) throws Exception {
        RecipientInfo recipientInfo;
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        if (choice.intValue() - 128 == 0) {
            logger.debug("RecipientInfo choice pskRecipientInfo");
            PreSharedKeyRecipientInfo info = PreSharedKeyRecipientInfo.getInstance(data);
            recipientInfo = new RecipientInfo(info);
            recipientInfo.setGoal(info.getGoal());
        } else if (choice.intValue() - 128 == 1) {
            logger.debug("RecipientInfo choice symmRecipInfo");
            SymmRecipInfo symmRecipInfo = SymmRecipInfo.getInstance(data);
            recipientInfo = new RecipientInfo(symmRecipInfo);
            recipientInfo.setGoal(symmRecipInfo.getGoal());
        } else if (choice.intValue() - 128 == 2) {
            logger.debug("RecipientInfo choice certRecipInfo");
            PKRecipientInfo instance = PKRecipientInfo.getInstance(data);
            recipientInfo = new RecipientInfo(instance, PKRecipientInfoType.CERT_RECIPINFO);
            recipientInfo.setGoal(instance.getGoal());
        } else if (choice.intValue() - 128 == 3) {
            logger.debug("RecipientInfo choice signedDataRecipInfo");
            PKRecipientInfo instance = PKRecipientInfo.getInstance(data);
            recipientInfo = new RecipientInfo(instance, PKRecipientInfoType.SIGNEDDATA_RECIPINFO);
            recipientInfo.setGoal(instance.getGoal());
        } else {
            logger.error("RecipientInfo choice is error " + choice.intValue());
            throw new Exception("unsupported RecipientInfo type " + choice.intValue());
        }
        return recipientInfo;
    }

    public PreSharedKeyRecipientInfo getPskRecipientInfo() {
        return this.pskRecipientInfo;
    }

    public SymmRecipInfo getSymmRecipInfo() {
        return this.symmRecipInfo;
    }

    public PKRecipientInfo getCertRecipInfo() {
        return this.certRecipInfo;
    }

    public PKRecipientInfo getSignedDataRecipInfo() {
        return this.signedDataRecipInfo;
    }

    @Override
    public Vector getChoiceValues() {
        Vector<Sequence> vector = new Vector<Sequence>();
        if (null != this.pskRecipientInfo) {
            vector.add(this.pskRecipientInfo);
        }
        if (null != this.symmRecipInfo) {
            vector.add(this.symmRecipInfo);
        }
        if (null != this.certRecipInfo) {
            vector.add(this.certRecipInfo);
        }
        if (null != this.signedDataRecipInfo) {
            vector.add(this.signedDataRecipInfo);
        }
        return vector;
    }
}

