/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.ATTbsCert;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedATRequest
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SharedATRequest.class);
    private Time32 currentTime;
    private ATTbsCert tbsCert;
    private PublicEncryptionKey encryptionKey;

    public SharedATRequest() {
        super(false, false);
    }

    public static SharedATRequest getInstance(byte[] data) throws Exception {
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        Time32 time32 = Time32.getInstance(data);
        SharedATRequest sharedATRequest = new SharedATRequest();
        sharedATRequest.setCurrentTime(time32);
        data = time32.getGoal();
        ATTbsCert atTbsCert = ATTbsCert.getInstance(data);
        sharedATRequest.setTbsCert(atTbsCert);
        data = atTbsCert.getGoal();
        PublicEncryptionKey encryptionKey = PublicEncryptionKey.getInstance(data);
        sharedATRequest.setEncryptionKey(encryptionKey);
        data = encryptionKey.getGoal();
        sharedATRequest.setGoal(data);
        return sharedATRequest;
    }

    public Time32 getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(Time32 currentTime) {
        this.currentTime = currentTime;
    }

    public ATTbsCert getTbsCert() {
        return this.tbsCert;
    }

    public void setTbsCert(ATTbsCert tbsCert) {
        this.tbsCert = tbsCert;
    }

    public PublicEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(PublicEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(2);
        vector.add(this.currentTime);
        vector.add(this.tbsCert);
        vector.add(this.encryptionKey);
        return vector;
    }
}

