/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.io.IOException;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Signature
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(Signature.class);
    private EccCurve eccCurve;
    private EccPoint r;
    private OctetString s;

    public Signature() {
        super(false, false);
    }

    public static Signature getInstance(byte[] data) throws Exception {
        Signature signature = new Signature();
        EccCurve eccCurve = EccCurve.getInstance(data);
        signature.setEccCurve(eccCurve);
        data = eccCurve.getGoal();
        EccPoint r = EccPoint.getInstance(data);
        signature.setR(r);
        data = r.getGoal();
        byte[] s = new byte[32];
        System.arraycopy(data, 0, s, 0, s.length);
        byte[] goal = new byte[data.length - s.length];
        System.arraycopy(data, s.length, goal, 0, goal.length);
        signature.setS(s);
        signature.setGoal(goal);
        return signature;
    }

    public EccCurve getEccCurve() {
        return this.eccCurve;
    }

    public void setEccCurve(EccCurve eccCurve) {
        this.eccCurve = eccCurve;
    }

    public EccPoint getR() {
        return this.r;
    }

    public void setR(byte[] r) throws IOException {
        EccPoint eccPoint = new EccPoint();
        OctetString xOnly = new OctetString();
        xOnly.setLength(32);
        xOnly.setString(r);
        eccPoint.setxOnly(xOnly);
        this.r = eccPoint;
    }

    public void setR(EccPoint r) {
        this.r = r;
    }

    public OctetString getS() {
        return this.s;
    }

    public void setS(OctetString s) {
        this.s = s;
    }

    public void setS(byte[] s) throws IOException {
        this.s = new OctetString();
        this.s.setLength(32);
        this.s.setString(s);
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.eccCurve);
        vector.add(this.r);
        vector.add(this.s);
        return vector;
    }
}

