/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.CertificateDigest;
import com.xdja.pki.itsca.oer.asn1.SequenceOfCertificate;
import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerInfo
extends Choice {
    private static Logger logger = LoggerFactory.getLogger(SignerInfo.class);
    private Null self;
    private SequenceOfCertificate certificate;
    private CertificateDigest certificateDigest;

    public SignerInfo(Null self) {
        this.self = self;
        this.certificate = null;
        this.certificateDigest = null;
    }

    public SignerInfo(SequenceOfCertificate certificate) {
        this.addIndex(1);
        this.self = null;
        this.certificate = certificate;
        this.certificateDigest = null;
    }

    public SignerInfo(CertificateDigest certificateDigest) {
        this.addIndex(2);
        this.self = null;
        this.certificate = null;
        this.certificateDigest = certificateDigest;
    }

    public static SignerInfo getInstance(byte[] data) throws Exception {
        SignerInfo signerInfo;
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        if (choice.intValue() - 128 == 0) {
            logger.debug("SignerInfo choice self");
            signerInfo = new SignerInfo(new Null());
            signerInfo.setGoal(data);
        } else if (choice.intValue() - 128 == 1) {
            logger.debug("SignerInfo choice certificate");
            SequenceOfCertificate certificate = SequenceOfCertificate.getInstance(data);
            signerInfo = new SignerInfo(certificate);
            signerInfo.setGoal(certificate.getGoal());
        } else if (choice.intValue() - 128 == 2) {
            logger.debug("SignerInfo choice certificateDigest");
            CertificateDigest certificateDigest = CertificateDigest.getInstance(data);
            signerInfo = new SignerInfo(certificateDigest);
            signerInfo.setGoal(certificateDigest.getGoal());
        } else {
            logger.error("SignerInfo choice is error " + choice.intValue());
            throw new Exception("unsupported SignerInfo type " + choice.intValue());
        }
        return signerInfo;
    }

    public Null getSelf() {
        return this.self;
    }

    public SequenceOfCertificate getCertificate() {
        return this.certificate;
    }

    public CertificateDigest getCertificateDigest() {
        return this.certificateDigest;
    }

    @Override
    public Vector getChoiceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        if (null != this.self) {
            vector.add(this.self);
        }
        if (null != this.certificate) {
            vector.add(this.certificate);
        }
        if (null != this.certificateDigest) {
            vector.add(this.certificateDigest);
        }
        return vector;
    }
}

