/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.PublicVerifyKey;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidList;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidSspList;
import com.xdja.pki.itsca.oer.asn1.SubjectAssurance;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAttribute
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SubjectAttribute.class);
    private PublicVerifyKey verifyKey;
    private PublicEncryptionKey encryptionKey;
    private SubjectAssurance assuranceLevel;
    private SequenceOfItsAidList itsAidList;
    private SequenceOfItsAidSspList itsSspList;

    public SubjectAttribute() {
        super(true, true);
    }

    public static SubjectAttribute getInstance(byte[] data) throws Exception {
        SubjectAttribute subjectAttribute = new SubjectAttribute();
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        BitByte bitByte = BitByte.setBit(choice.intValue());
        List<Integer> integers = bitByte.readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        PublicVerifyKey publicVerifyKey = PublicVerifyKey.getInstance(data);
        data = publicVerifyKey.getGoal();
        if (integers.contains(0)) {
            logger.debug("SubjectAttribute choice Extension");
        }
        if (integers.contains(1)) {
            logger.debug("SubjectAttribute choice encryptionKey");
            PublicEncryptionKey encryptionKey = PublicEncryptionKey.getInstance(data);
            subjectAttribute.setEncryptionKey(encryptionKey);
            data = encryptionKey.getGoal();
        }
        if (integers.contains(2)) {
            logger.debug("SubjectAttribute choice assuranceLevel");
            goal = new byte[1];
            System.arraycopy(data, 0, goal, 0, goal.length);
            SubjectAssurance assuranceLevel = new SubjectAssurance(goal);
            subjectAttribute.setAssuranceLevel(assuranceLevel);
            goal = new byte[data.length - 1];
            System.arraycopy(data, 1, goal, 0, goal.length);
            data = goal;
        }
        if (integers.contains(3)) {
            logger.debug("SubjectAttribute choice itsAidList");
            SequenceOfItsAidList itsAidList = SequenceOfItsAidList.getInstance(data);
            subjectAttribute.setItsAidList(itsAidList);
            data = itsAidList.getGoal();
        }
        if (integers.contains(4)) {
            logger.debug("SubjectAttribute choice itsSspList");
            SequenceOfItsAidSspList itsSspList = SequenceOfItsAidSspList.getInstance(data);
            subjectAttribute.setItsSspList(itsSspList);
            data = itsSspList.getGoal();
        }
        subjectAttribute.setVerifyKey(publicVerifyKey);
        subjectAttribute.setGoal(data);
        return subjectAttribute;
    }

    public void setVerifyKey(PublicVerifyKey verifyKey) {
        this.verifyKey = verifyKey;
    }

    public void setEncryptionKey(PublicEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public void setAssuranceLevel(SubjectAssurance assuranceLevel) {
        this.assuranceLevel = assuranceLevel;
    }

    public void setItsAidList(SequenceOfItsAidList itsAidList) {
        this.itsAidList = itsAidList;
    }

    public void setItsSspList(SequenceOfItsAidSspList itsSspList) {
        this.itsSspList = itsSspList;
    }

    public PublicVerifyKey getVerifyKey() {
        return this.verifyKey;
    }

    public PublicEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public SubjectAssurance getAssuranceLevel() {
        return this.assuranceLevel;
    }

    public SequenceOfItsAidList getItsAidList() {
        return this.itsAidList;
    }

    public SequenceOfItsAidSspList getItsSspList() {
        return this.itsSspList;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (this.encryptionKey != null) {
            optionals.add(7);
        }
        if (this.assuranceLevel != null) {
            optionals.add(6);
        }
        if (this.itsAidList != null) {
            optionals.add(5);
        }
        if (this.itsSspList != null) {
            optionals.add(4);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.verifyKey);
        vector.add(this.encryptionKey);
        vector.add(this.assuranceLevel);
        vector.add(this.itsAidList);
        vector.add(this.itsSspList);
        return vector;
    }
}

