/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetricAlgorithm
extends Enumerated {
    private static Logger logger = LoggerFactory.getLogger(SymmetricAlgorithm.class);
    public static final Enumerated.Value SGD_SM4_ECB = new Enumerated.Value(0, "SGD_SM4_ECB");
    public static final Enumerated.Value SGD_SM4_CBC = new Enumerated.Value(1, "SGD_SM4_CBC");
    public static final Enumerated.Value SGD_SM4_CFB = new Enumerated.Value(2, "SGD_SM4_CFB");
    public static final Enumerated.Value SGD_SM4_EFB = new Enumerated.Value(3, "SGD_SM4_EFB");
    public static final Enumerated.Value SGD_SM4_OFB = new Enumerated.Value(4, "SGD_SM4_OFB");
    public static final Enumerated.Value AES_128_CCM = new Enumerated.Value(5, "AES_128_CCM");

    public static SymmetricAlgorithm getInstance(byte[] data) throws Exception {
        SymmetricAlgorithm symmetricAlgorithm;
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        if (choice.intValue() == 0) {
            logger.debug("SymmetricAlgorithm choice SGD_SM4_ECB");
            symmetricAlgorithm = new SymmetricAlgorithm(SGD_SM4_ECB);
        } else if (choice.intValue() == 1) {
            logger.debug("SymmetricAlgorithm choice SGD_SM4_CBC");
            symmetricAlgorithm = new SymmetricAlgorithm(SGD_SM4_CBC);
        } else if (choice.intValue() == 2) {
            logger.debug("SymmetricAlgorithm choice SGD_SM4_CFB");
            symmetricAlgorithm = new SymmetricAlgorithm(SGD_SM4_CFB);
        } else if (choice.intValue() == 3) {
            logger.debug("SymmetricAlgorithm choice SGD_SM4_EFB");
            symmetricAlgorithm = new SymmetricAlgorithm(SGD_SM4_EFB);
        } else if (choice.intValue() == 4) {
            logger.debug("SymmetricAlgorithm choice SGD_SM4_OFB");
            symmetricAlgorithm = new SymmetricAlgorithm(SGD_SM4_OFB);
        } else if (choice.intValue() == 5) {
            logger.debug("SymmetricAlgorithm choice AES_128_CCM");
            symmetricAlgorithm = new SymmetricAlgorithm(AES_128_CCM);
        } else {
            logger.error("SymmetricAlgorithm choice is error " + choice.intValue());
            throw new Exception("unsupported SymmetricAlgorithm type " + choice.intValue());
        }
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        symmetricAlgorithm.setGoal(goal);
        return symmetricAlgorithm;
    }

    public SymmetricAlgorithm(Enumerated.Value value) {
        super(value);
        this.addValueToList(SGD_SM4_ECB);
        this.addValueToList(SGD_SM4_CBC);
        this.addValueToList(SGD_SM4_CFB);
        this.addValueToList(SGD_SM4_EFB);
        this.addValueToList(SGD_SM4_OFB);
        this.addValueToList(AES_128_CCM);
    }

    @Override
    public Enumerated.Value readValue() throws IOException {
        return this.readValue();
    }
}

