/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.HeaderInfo;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TBSData
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(TBSData.class);
    private HeaderInfo headerInfo;
    private OctetString data;
    private OctetString extHash;

    public TBSData() {
        super(false, true);
    }

    public static TBSData getInstance(byte[] data) throws Exception {
        TBSData tbsData = new TBSData();
        BigInteger optional = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        HeaderInfo headerInfo = HeaderInfo.getInstance(data);
        data = headerInfo.getGoal();
        tbsData.setHeaderInfo(headerInfo);
        List<Integer> integers = BitByte.setBit(optional.intValue()).readIndexes();
        if (integers.contains(0)) {
            logger.debug("TBSData choice data");
            OctetString octetString = OctetString.getInstance(data);
            data = octetString.getGoal();
            tbsData.setData(octetString);
        }
        if (integers.contains(1)) {
            logger.debug("TBSData choice extHash");
            OctetString extHash = new OctetString();
            extHash.setLength(32);
            goal = new byte[32];
            System.arraycopy(data, 0, goal, 0, goal.length);
            extHash.setString(goal);
            tbsData.setExtHash(extHash);
            goal = new byte[data.length - 32];
            System.arraycopy(data, 32, goal, 0, goal.length);
            data = goal;
        }
        tbsData.setGoal(data);
        return tbsData;
    }

    public void setHeaderInfo(HeaderInfo headerInfo) {
        this.headerInfo = headerInfo;
    }

    public void setData(OctetString data) {
        this.data = data;
    }

    public void setExtHash(OctetString extHash) {
        this.extHash = extHash;
    }

    public HeaderInfo getHeaderInfo() {
        return this.headerInfo;
    }

    public OctetString getData() {
        return this.data;
    }

    public OctetString getExtHash() {
        return this.extHash;
    }

    public void setData(byte[] data) {
        this.data = new OctetString();
        this.data.setString(data);
    }

    public void setExtHash(byte[] extHash) {
        this.extHash = new OctetString();
        this.extHash.setLength(32);
        this.extHash.setString(extHash);
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (null != this.data) {
            optionals.add(7);
        }
        if (null != this.extHash) {
            optionals.add(6);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.headerInfo);
        vector.add(this.data);
        vector.add(this.extHash);
        return vector;
    }
}

