/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.Elevation;
import com.xdja.pki.itsca.oer.asn1.Latitude;
import com.xdja.pki.itsca.oer.asn1.Longitude;
import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreeDLocation
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(ThreeDLocation.class);
    private Latitude latitude;
    private Longitude longitude;
    private Elevation elevation;

    public ThreeDLocation() {
        super(false, false);
    }

    public void setLatitude(Latitude latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(Longitude longitude) {
        this.longitude = longitude;
    }

    public void setElevation(Elevation elevation) {
        this.elevation = elevation;
    }

    public Latitude getLatitude() {
        return this.latitude;
    }

    public Longitude getLongitude() {
        return this.longitude;
    }

    public Elevation getElevation() {
        return this.elevation;
    }

    public static ThreeDLocation getInstance(byte[] data) throws Exception {
        Int anInt = Latitude.getInstance(data, 4);
        Latitude latitude = new Latitude(anInt.getValue());
        data = anInt.getGoal();
        anInt = Longitude.getInstance(data, 4);
        Longitude longitude = new Longitude(anInt.getValue());
        data = anInt.getGoal();
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)2);
        Elevation elevation = new Elevation(integer.intValue());
        byte[] goal = new byte[data.length - 2];
        System.arraycopy(data, 2, goal, 0, goal.length);
        data = goal;
        ThreeDLocation threeDLocation = new ThreeDLocation();
        threeDLocation.setLatitude(latitude);
        threeDLocation.setElevation(elevation);
        threeDLocation.setLongitude(longitude);
        threeDLocation.setGoal(data);
        return threeDLocation;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.latitude);
        vector.add(this.longitude);
        vector.add(this.elevation);
        return vector;
    }
}

