/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.GeographicRegion;
import com.xdja.pki.itsca.oer.asn1.ValidityPeriod;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidityRestriction
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(ValidityRestriction.class);
    private ValidityPeriod validityPeriod;
    private GeographicRegion geographicRegion;

    public ValidityRestriction() {
        super(true, true);
    }

    public static ValidityRestriction getInstance(byte[] data) throws Exception {
        ValidityRestriction validityRestriction = new ValidityRestriction();
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List<Integer> integers = BitByte.setBit(choice.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        ValidityPeriod validityPeriod = ValidityPeriod.getInstance(data);
        data = validityPeriod.getGoal();
        validityRestriction.setValidityPeriod(validityPeriod);
        if (integers.contains(0)) {
            // empty if block
        }
        if (integers.contains(1)) {
            GeographicRegion geographicRegion = GeographicRegion.getInstance(data);
            validityRestriction.setGeographicRegion(geographicRegion);
            data = geographicRegion.getGoal();
        }
        validityRestriction.setGoal(data);
        return validityRestriction;
    }

    public ValidityPeriod getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(ValidityPeriod validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public GeographicRegion getGeographicRegion() {
        return this.geographicRegion;
    }

    public void setGeographicRegion(GeographicRegion geographicRegion) {
        this.geographicRegion = geographicRegion;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<Choice> vector = new Vector<Choice>();
        if (this.geographicRegion != null) {
            this.addOptional(Arrays.asList(7));
        }
        vector.add(this.validityPeriod);
        vector.add(this.geographicRegion);
        return vector;
    }
}

