/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.base;

import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class Enumerated
extends OERObject {
    private List<Value> enumList = new ArrayList<Value>();
    private Value value;

    private Enumerated() {
    }

    public Enumerated(Value value) {
        this.value = value;
    }

    public static Enumerated getInstance(byte[] obj) throws Exception {
        Enumerated enumerated = new Enumerated();
        enumerated.fromByteArray(obj);
        return enumerated;
    }

    public void addValueToList(Value value) {
        this.enumList.add(value);
    }

    public Value readValue() throws IOException {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])this.getEncode());
        for (Value v : this.enumList) {
            if (v.index != integer.intValue()) continue;
            return v;
        }
        throw new IOException("can not get value for index " + this.readInt());
    }

    @Override
    public Vector getValues() {
        int enumLen = this.enumList.size();
        if (enumLen >= 0 && enumLen <= 127) {
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(this.value.getIndex());
            return vector;
        }
        return null;
    }

    public static class Value {
        private int index;
        private String desc;

        public Value(int index, String desc) {
            this.index = index;
            this.desc = desc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            return this.index == value.index && Objects.equals(this.desc, value.desc);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.desc);
        }

        public int getIndex() {
            return this.index;
        }

        public String getDesc() {
            return this.desc;
        }

        public String toString() {
            return "Value{index=" + this.index + ", desc='" + this.desc + '\'' + '}';
        }
    }
}

