/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.base;

import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class Int
extends OERObject {
    private int length = -1;
    private byte[] value;

    public Int(byte value, int length) {
        this.length = length;
        this.value = ByteBuffer.allocate(1).put(value).array();
    }

    public Int(short value, int length) {
        this.length = length;
        this.value = ByteBuffer.allocate(2).putShort(value).array();
    }

    public Int(int value, int length) {
        this.length = length;
        this.value = ByteBuffer.allocate(4).putInt(value).array();
    }

    public Int(long value, int length) {
        this.length = length;
        this.value = ByteBuffer.allocate(8).putLong(value).array();
    }

    public Int(long value) {
        this.value = BigInteger.valueOf(value).toByteArray();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getValue() {
        return this.toIntValue(this.value);
    }

    private int toIntValue(byte[] v) {
        return new BigInteger(v).intValue();
    }

    public byte[] readLength() throws IOException {
        int len = this.readInt();
        return this.readBytes(len);
    }

    public byte[] readString(int len) throws IOException {
        return this.readBytes(len);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Int getInstance(byte[] data, int ... len) throws Exception {
        Int anInt;
        BigInteger length = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        if (len.length == 0) {
            if (length.intValue() - 128 > 0) {
                BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)1, (int)(length.intValue() - 128));
                byte[] goal = new byte[integer.intValue()];
                System.arraycopy(data, 1 + (length.intValue() - 128), goal, 0, goal.length);
                BigInteger value = BigIntegers.fromUnsignedByteArray((byte[])goal);
                anInt = new Int(value.intValue());
                byte[] dest = new byte[data.length - 1 - (length.intValue() - 128) - integer.intValue()];
                System.arraycopy(data, 1 + (length.intValue() - 128) + integer.intValue(), dest, 0, dest.length);
                anInt.setGoal(dest);
                return anInt;
            } else {
                if (length.intValue() - 128 >= 0) throw new Exception("unsupported this oer int  header  " + length.intValue());
                byte[] goal = new byte[length.intValue()];
                System.arraycopy(data, 1, goal, 0, goal.length);
                BigInteger value = BigIntegers.fromUnsignedByteArray((byte[])goal);
                anInt = new Int(value.intValue());
                byte[] dest = new byte[data.length - 1 - length.intValue()];
                System.arraycopy(data, 1 + length.intValue(), dest, 0, dest.length);
                anInt.setGoal(dest);
            }
            return anInt;
        } else {
            BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)len[0]);
            anInt = new Int(integer.intValue(), len[0]);
            byte[] dest = new byte[data.length - len[0]];
            System.arraycopy(data, len[0], dest, 0, dest.length);
            anInt.setGoal(dest);
        }
        return anInt;
    }

    @Override
    public Vector getValues() throws IOException {
        Vector<byte[]> vector = new Vector<byte[]>();
        if (this.length != -1) {
            if (this.value.length > this.length) {
                throw new IOException("value len:" + this.value.length + " is greater than " + this.length);
            }
        } else {
            this.setLengthPrefix(this.value.length);
        }
        vector.add(this.value);
        return vector;
    }
}

