/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.base;

import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Uint64
extends OERObject {
    protected static Logger logger = LoggerFactory.getLogger(Uint64.class);
    protected byte[] bytes;

    public Uint64(long l) throws IOException {
        this(BigInteger.valueOf(l));
    }

    public Uint64(String str) throws IOException {
        this(new BigInteger(str));
    }

    public Uint64(BigInteger i) throws IOException {
        this(BigIntegers.asUnsignedByteArray((BigInteger)i));
    }

    public static Uint64 getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)8);
        Uint64 uint64 = new Uint64(integer.longValue());
        byte[] goal = new byte[data.length - 8];
        System.arraycopy(data, 8, goal, 0, goal.length);
        uint64.setGoal(goal);
        return uint64;
    }

    public Uint64(byte[] byteArray) throws IOException {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])byteArray);
        if (new BigInteger("18446744073709551615").compareTo(integer) >= 0 && new BigInteger("0").compareTo(integer) <= 0) {
            if (byteArray.length > 8) {
                throw new IOException("Uint64 must less than 8 length");
            }
        } else {
            throw new IOException("Uint64 must in 0-18446744073709551616");
        }
        this.bytes = new byte[8];
        System.arraycopy(byteArray, 0, this.bytes, this.bytes.length - byteArray.length, byteArray.length);
    }

    private Uint64() {
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public Vector getValues() throws IOException {
        Vector<byte[]> vector = new Vector<byte[]>();
        vector.add(this.bytes);
        return vector;
    }
}

