/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.batc;

import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.asn1.batc.BATCResponseCodeEnum;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;

public class BATCAuthorizationResponseCode
extends Enumerated {
    public static final Enumerated.Value OK = new Enumerated.Value(0, "ok");
    public static final Enumerated.Value ITS_AA_CANT_PRASE = new Enumerated.Value(1, " its-aa-cantparse");
    public static final Enumerated.Value ITS_AA_BAD_CONTENTTYPE = new Enumerated.Value(2, "its-aa-badcontenttype");
    public static final Enumerated.Value ITS_AA_IMONTTHERE_CIPIENT = new Enumerated.Value(3, "its-aa-imnottherecipient");
    public static final Enumerated.Value ITS_AA_UNKNOW_ENCRYPTION_ALGORITHM = new Enumerated.Value(4, "its-aa-unknownencryptionalgorithm");
    public static final Enumerated.Value ITS_AA_DECRYPTION_FAILED = new Enumerated.Value(5, "its-aa-decryptionfailed");
    public static final Enumerated.Value ITS_AA_KEYSDONTMATCH = new Enumerated.Value(6, "its-aa-keysdontmatch");
    public static final Enumerated.Value ITS_AA_INCOMPLETEREQUEST = new Enumerated.Value(7, "its-aa-incompleterequest");
    public static final Enumerated.Value ITS_AA_INVALIDENCRYPTIONKEY = new Enumerated.Value(8, "its-aa-invalidencryptionkey");
    public static final Enumerated.Value ITS_AA_OUTOFSYNCREQUEST = new Enumerated.Value(9, "its-aa-outofsyncrequest");
    public static final Enumerated.Value ITS_AA_UNKNOWEA = new Enumerated.Value(10, "its-aa-unknownea");
    public static final Enumerated.Value ITS_AA_INVALIDEA = new Enumerated.Value(11, "its-aa-invalidea");
    public static final Enumerated.Value ITS_AA_DENIEDPERMISSIONS = new Enumerated.Value(12, "its-aa-deniedpermissions");
    public static final Enumerated.Value AA_EA_CANTREACHEA = new Enumerated.Value(13, "aa-ea-cantreachea");
    public static final Enumerated.Value EE_AA_CANT_PRASE = new Enumerated.Value(14, "ea-aa-cantparse");
    public static final Enumerated.Value EE_AA_BAD_CONTENTTYPE = new Enumerated.Value(15, "ee-aa-badcontenttype");
    public static final Enumerated.Value EE_AA_IMONTTHERE_CIPIENT = new Enumerated.Value(16, "ee-aa-imnottherecipient");
    public static final Enumerated.Value EE_AA_UNKNOW_ENCRYPTION_ALGORITHM = new Enumerated.Value(17, "ee-aa-unknownencryptionalgorithm");
    public static final Enumerated.Value EE_AA_DECRYPTION_FAILED = new Enumerated.Value(18, "ee-aa-decryptionfailed");
    public static final Enumerated.Value INVALID_AA = new Enumerated.Value(19, "invalidaa");
    public static final Enumerated.Value INVALID_AA_SIGNATURE = new Enumerated.Value(20, "invalidaasignature");
    public static final Enumerated.Value WRONGEA = new Enumerated.Value(21, "wrongea");
    public static final Enumerated.Value UNKNOWN_ITS = new Enumerated.Value(22, "unknownits");
    public static final Enumerated.Value INVALID_SIGNATURE = new Enumerated.Value(23, "invalidsignature");
    public static final Enumerated.Value INVALID_ENCRYPTION_KEY = new Enumerated.Value(24, "invalidencryptionkey");
    public static final Enumerated.Value DENIED_PERMISSIONS = new Enumerated.Value(25, "deniedpermissions");
    public static final Enumerated.Value DENIED_TOO_MANY_CERTS = new Enumerated.Value(26, "deniedtoomanycerts");

    public BATCAuthorizationResponseCode(Enumerated.Value value) {
        super(value);
        this.addValueToList(OK);
        this.addValueToList(ITS_AA_CANT_PRASE);
        this.addValueToList(ITS_AA_BAD_CONTENTTYPE);
        this.addValueToList(ITS_AA_IMONTTHERE_CIPIENT);
        this.addValueToList(ITS_AA_UNKNOW_ENCRYPTION_ALGORITHM);
        this.addValueToList(ITS_AA_DECRYPTION_FAILED);
        this.addValueToList(ITS_AA_KEYSDONTMATCH);
        this.addValueToList(ITS_AA_INCOMPLETEREQUEST);
        this.addValueToList(ITS_AA_INVALIDENCRYPTIONKEY);
        this.addValueToList(ITS_AA_OUTOFSYNCREQUEST);
        this.addValueToList(ITS_AA_UNKNOWEA);
        this.addValueToList(ITS_AA_INVALIDEA);
        this.addValueToList(ITS_AA_DENIEDPERMISSIONS);
        this.addValueToList(AA_EA_CANTREACHEA);
        this.addValueToList(EE_AA_CANT_PRASE);
        this.addValueToList(EE_AA_BAD_CONTENTTYPE);
        this.addValueToList(EE_AA_IMONTTHERE_CIPIENT);
        this.addValueToList(EE_AA_UNKNOW_ENCRYPTION_ALGORITHM);
        this.addValueToList(EE_AA_DECRYPTION_FAILED);
        this.addValueToList(INVALID_AA);
        this.addValueToList(INVALID_AA_SIGNATURE);
        this.addValueToList(WRONGEA);
        this.addValueToList(UNKNOWN_ITS);
        this.addValueToList(INVALID_SIGNATURE);
        this.addValueToList(INVALID_ENCRYPTION_KEY);
        this.addValueToList(DENIED_PERMISSIONS);
        this.addValueToList(DENIED_TOO_MANY_CERTS);
    }

    public static BATCAuthorizationResponseCode getInstance(byte[] data) throws Exception {
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        Enumerated.Value value = BATCResponseCodeEnum.AuthorizationResponseCode.getValue(choice.intValue());
        BATCAuthorizationResponseCode responseCode = new BATCAuthorizationResponseCode(value);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        responseCode.setGoal(goal);
        return responseCode;
    }
}

