/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.batc;

import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.batc.BATCAuthorizationValidationResponseCode;
import com.xdja.pki.itsca.oer.asn1.batc.BATCCertificateSubjectAttributes;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class BATCAuthorizationValidationResponse
extends Sequence {
    private OctetString requestHash;
    private BATCAuthorizationValidationResponseCode responseCode;
    private BATCCertificateSubjectAttributes confirmedSubjectAttributes;

    public BATCAuthorizationValidationResponse() {
        super(true, true);
    }

    public static BATCAuthorizationValidationResponse getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCAuthorizationValidationResponse response = new BATCAuthorizationValidationResponse();
        OctetString requestHash = OctetString.getInstance(data, 16);
        data = requestHash.getGoal();
        BATCAuthorizationValidationResponseCode responseCode = BATCAuthorizationValidationResponseCode.getInstance(data);
        data = responseCode.getGoal();
        if (integers.contains(0)) {
            // empty if block
        }
        if (integers.contains(1)) {
            BATCCertificateSubjectAttributes confirmedSubjectAttributes = BATCCertificateSubjectAttributes.getInstance(data);
            response.setConfirmedSubjectAttributes(confirmedSubjectAttributes);
            data = confirmedSubjectAttributes.getGoal();
        }
        response.setRequestHash(requestHash);
        response.setResponseCode(responseCode);
        response.setGoal(data);
        return response;
    }

    public OctetString getRequestHash() {
        return this.requestHash;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public BATCAuthorizationValidationResponseCode getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(BATCAuthorizationValidationResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public BATCCertificateSubjectAttributes getConfirmedSubjectAttributes() {
        return this.confirmedSubjectAttributes;
    }

    public void setConfirmedSubjectAttributes(BATCCertificateSubjectAttributes confirmedSubjectAttributes) {
        this.confirmedSubjectAttributes = confirmedSubjectAttributes;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (this.confirmedSubjectAttributes != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.requestHash);
        vector.add(this.responseCode);
        vector.add(this.confirmedSubjectAttributes);
        return vector;
    }
}

