/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.batc;

import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.batc.BATCHostname;
import com.xdja.pki.itsca.oer.asn1.batc.BATCLinkageData;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class BATCCertificateId
extends Choice {
    private BATCLinkageData linkageData;
    private BATCHostname name;
    private OctetString binaryId;
    private Null none;

    public static BATCCertificateId getInstance(byte[] data) throws Exception {
        BATCCertificateId certificateId = new BATCCertificateId();
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        switch (choice.intValue()) {
            case 128: {
                BATCLinkageData linkageData = BATCLinkageData.getInstance(data);
                certificateId.setLinkageData(linkageData);
                certificateId.setGoal(linkageData.getGoal());
                break;
            }
            case 129: {
                BATCHostname name = BATCHostname.getInstance(data);
                certificateId.setName(name);
                certificateId.setGoal(name.getGoal());
                break;
            }
            case 130: {
                OctetString binaryId = OctetString.getInstance(data);
                certificateId.setBinaryId(binaryId);
                certificateId.setGoal(binaryId.getGoal());
                break;
            }
            case 131: {
                certificateId.setNone(new Null());
                certificateId.setGoal(data);
                break;
            }
            default: {
                throw new Exception("unknown choice value" + choice);
            }
        }
        return certificateId;
    }

    public BATCLinkageData getLinkageData() {
        return this.linkageData;
    }

    public void setLinkageData(BATCLinkageData linkageData) {
        this.linkageData = linkageData;
    }

    public BATCHostname getName() {
        return this.name;
    }

    public void setName(BATCHostname name) {
        this.addIndex(1);
        this.name = name;
    }

    public OctetString getBinaryId() {
        return this.binaryId;
    }

    public void setBinaryId(OctetString binaryId) {
        this.addIndex(2);
        this.binaryId = binaryId;
    }

    public Null getNone() {
        return this.none;
    }

    public void setNone(Null none) {
        this.addIndex(3);
        this.none = none;
    }

    @Override
    public Vector getChoiceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.linkageData);
        vector.add(this.name);
        vector.add(this.binaryId);
        vector.add(this.none);
        return vector;
    }
}

