/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.batc;

import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.app.SecureMessageUtils;
import com.xdja.pki.itsca.oer.app.SecuredMessageBuilder;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.GeographicRegion;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.ItsAid;
import com.xdja.pki.itsca.oer.asn1.ItsAidInt;
import com.xdja.pki.itsca.oer.asn1.ItsAidSsp;
import com.xdja.pki.itsca.oer.asn1.Latitude;
import com.xdja.pki.itsca.oer.asn1.Longitude;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.PublicVerifyKey;
import com.xdja.pki.itsca.oer.asn1.RectangularRegion;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidSspList;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRectangularRegion;
import com.xdja.pki.itsca.oer.asn1.SymmetricAlgorithm;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.TimeStartAndEnd;
import com.xdja.pki.itsca.oer.asn1.TwoDLocation;
import com.xdja.pki.itsca.oer.asn1.ValidityPeriod;
import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.batc.BATCCertificateFormat;
import com.xdja.pki.itsca.oer.asn1.batc.BATCCertificateId;
import com.xdja.pki.itsca.oer.asn1.batc.BATCCertificateSubjectAttributes;
import com.xdja.pki.itsca.oer.asn1.batc.BATCEnrollmentCertResponseData;
import com.xdja.pki.itsca.oer.asn1.batc.BATCEnrolmentResponseCode;
import com.xdja.pki.itsca.oer.asn1.batc.BATCHostname;
import com.xdja.pki.itsca.oer.asn1.batc.BATCITSDataContent;
import com.xdja.pki.itsca.oer.asn1.batc.BATCInnerEcRequest;
import com.xdja.pki.itsca.oer.asn1.batc.BATCInnerEcRequestSignedForPop;
import com.xdja.pki.itsca.oer.asn1.batc.BATCInnerEcResponse;
import com.xdja.pki.itsca.oer.asn1.batc.BATCPublicKeys;
import com.xdja.pki.itsca.oer.cert.EccPointBuilder;
import com.xdja.pki.itsca.oer.enums.EccCurveTypeEnum;
import com.xdja.pki.itsca.oer.enums.EccPointTypeEnum;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.security.PrivateKey;
import java.security.PublicKey;

public class BATCECApplyBuilder {
    public static BATCITSDataContent buildECApplyRequest(int privateKeyIndex, String privateKeyPassword, String imei, String hostName) throws Exception {
        byte[] imeiHash = GMSSLSM3DigestUtils.digestByBC((byte[])imei.getBytes());
        BATCITSDataContent batcitsDataContent = new BATCITSDataContent();
        OctetString itsId = new OctetString();
        itsId.setString(imeiHash);
        BATCCertificateFormat certificateFormat = new BATCCertificateFormat(2);
        BATCInnerEcRequest batcInnerEcRequest = new BATCInnerEcRequest();
        BATCPublicKeys batcPublicKeys = new BATCPublicKeys();
        PublicKey publicKey = GMSSLSM2KeyUtils.getEncryptPublicKeyByYunhsm((int)privateKeyIndex);
        PublicVerifyKey verifyKey = new PublicVerifyKey();
        verifyKey.setEccPoint(EccPointBuilder.build(publicKey, EccPointTypeEnum.UNCOMPRESSED));
        verifyKey.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        batcPublicKeys.setVerifyKey(verifyKey);
        PublicEncryptionKey publicEncryptionKey = new PublicEncryptionKey();
        publicEncryptionKey.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_ECB));
        publicEncryptionKey.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        publicEncryptionKey.setPublicKey(EccPointBuilder.build(publicKey, EccPointTypeEnum.COMPRESSED_Y));
        batcPublicKeys.setEncryptionKey(publicEncryptionKey);
        BATCCertificateSubjectAttributes subjectAttributes = new BATCCertificateSubjectAttributes();
        BATCCertificateId batcCertificateId = new BATCCertificateId();
        BATCHostname batcHostname = new BATCHostname();
        batcHostname.setString(hostName.getBytes());
        batcCertificateId.setName(batcHostname);
        subjectAttributes.setId(batcCertificateId);
        ValidityPeriod validityPeriod = new ValidityPeriod();
        TimeStartAndEnd timeStartAndEnd = new TimeStartAndEnd();
        timeStartAndEnd.setStartValidity(new Time32(TimeUtils.getNowTime()));
        timeStartAndEnd.setEndValidity(new Time32(TimeUtils.getTimeAfterYear(1)));
        validityPeriod.setTimeStartAndEnd(timeStartAndEnd);
        subjectAttributes.setValidityPeriod(validityPeriod);
        GeographicRegion geographicRegion = new GeographicRegion();
        SequenceOfRectangularRegion regions = new SequenceOfRectangularRegion();
        RectangularRegion region = new RectangularRegion();
        TwoDLocation twoDLocation = new TwoDLocation();
        twoDLocation.setLongitude(new Longitude(123));
        twoDLocation.setLatitude(new Latitude(465));
        region.setNorthWest(twoDLocation);
        region.setSouthEast(twoDLocation);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        geographicRegion.setRectangularRegion(regions);
        subjectAttributes.setRegion(geographicRegion);
        SequenceOfItsAidSspList itsAidSspList = new SequenceOfItsAidSspList();
        ItsAidSsp itsAidSsp = new ItsAidSsp();
        itsAidSsp.setItsAid(ItsAid.TRAFFIC_LIGHT_APPLICATION);
        itsAidSsp.setServiceSpecificPermissions(new byte[]{1, 16});
        itsAidSspList.addItsAidSsp(itsAidSsp);
        subjectAttributes.setAppPermissions(itsAidSspList);
        batcInnerEcRequest.setItsId(itsId);
        batcInnerEcRequest.setCertificateFormat(certificateFormat);
        batcInnerEcRequest.setPublicKeys(batcPublicKeys);
        batcInnerEcRequest.setRequestedSubjectAttributes(subjectAttributes);
        SecuredMessage securedMessage = SecureMessageUtils.buildSignSecuredMessage(null, new HashAlgorithm(HashAlgorithm.SGD_SM3), new ItsAidInt(623L), privateKeyIndex, privateKeyPassword, batcInnerEcRequest.getEncode());
        BATCInnerEcRequestSignedForPop signedForPop = new BATCInnerEcRequestSignedForPop();
        signedForPop.setPayload(securedMessage.getPayload());
        signedForPop.setVersion(securedMessage.getVersion());
        batcitsDataContent.setEnrolmentRequest(signedForPop);
        return batcitsDataContent;
    }

    public static BATCITSDataContent buildNistECApplyRequest(int privateKeyIndex, String privateKeyPassword, String imei, String hostName) throws Exception {
        byte[] imeiHash = GMSSLSHA256DigestUtils.digestByBC((byte[])imei.getBytes());
        BATCITSDataContent batcitsDataContent = new BATCITSDataContent();
        OctetString itsId = new OctetString();
        itsId.setString(imeiHash);
        BATCCertificateFormat certificateFormat = new BATCCertificateFormat(2);
        BATCInnerEcRequest batcInnerEcRequest = new BATCInnerEcRequest();
        BATCPublicKeys batcPublicKeys = new BATCPublicKeys();
        PublicVerifyKey verifyKey = new PublicVerifyKey();
        PublicKey publicKey = GMSSLECKeyUtils.getSignPublicKeyByYunhsm((int)privateKeyIndex, (String)GMSSLECKeyUtils.NISTp256);
        verifyKey.setEccPoint(EccPointBuilder.build(publicKey, EccPointTypeEnum.UNCOMPRESSED));
        verifyKey.setEccCurve(new EccCurve(EccCurve.NIST_P_256));
        batcPublicKeys.setVerifyKey(verifyKey);
        PublicEncryptionKey publicEncryptionKey = new PublicEncryptionKey();
        publicEncryptionKey.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.AES_128_CCM));
        publicEncryptionKey.setEccCurve(new EccCurve(EccCurve.NIST_P_256));
        publicEncryptionKey.setPublicKey(EccPointBuilder.build(publicKey, EccPointTypeEnum.COMPRESSED_Y));
        batcPublicKeys.setEncryptionKey(publicEncryptionKey);
        BATCCertificateSubjectAttributes subjectAttributes = new BATCCertificateSubjectAttributes();
        BATCCertificateId batcCertificateId = new BATCCertificateId();
        BATCHostname batcHostname = new BATCHostname();
        batcHostname.setString(hostName.getBytes());
        batcCertificateId.setName(batcHostname);
        subjectAttributes.setId(batcCertificateId);
        ValidityPeriod validityPeriod = new ValidityPeriod();
        TimeStartAndEnd timeStartAndEnd = new TimeStartAndEnd();
        timeStartAndEnd.setStartValidity(new Time32(TimeUtils.getNowTime()));
        timeStartAndEnd.setEndValidity(new Time32(TimeUtils.getTimeAfterYear(1)));
        validityPeriod.setTimeStartAndEnd(timeStartAndEnd);
        subjectAttributes.setValidityPeriod(validityPeriod);
        GeographicRegion geographicRegion = new GeographicRegion();
        SequenceOfRectangularRegion regions = new SequenceOfRectangularRegion();
        RectangularRegion region = new RectangularRegion();
        TwoDLocation twoDLocation = new TwoDLocation();
        twoDLocation.setLongitude(new Longitude(123));
        twoDLocation.setLatitude(new Latitude(465));
        region.setNorthWest(twoDLocation);
        region.setSouthEast(twoDLocation);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        regions.addRectangularRegion(region);
        geographicRegion.setRectangularRegion(regions);
        subjectAttributes.setRegion(geographicRegion);
        SequenceOfItsAidSspList itsAidSspList = new SequenceOfItsAidSspList();
        ItsAidSsp itsAidSsp = new ItsAidSsp();
        itsAidSsp.setItsAid(ItsAid.TRAFFIC_LIGHT_APPLICATION);
        itsAidSsp.setServiceSpecificPermissions(new byte[]{1, 16});
        itsAidSspList.addItsAidSsp(itsAidSsp);
        subjectAttributes.setAppPermissions(itsAidSspList);
        batcInnerEcRequest.setItsId(itsId);
        batcInnerEcRequest.setCertificateFormat(certificateFormat);
        batcInnerEcRequest.setPublicKeys(batcPublicKeys);
        batcInnerEcRequest.setRequestedSubjectAttributes(subjectAttributes);
        SecuredMessage securedMessage = SecuredMessageBuilder.buildSelfSignedDataSecuredMessage(new ItsAidInt(623L), (PrivateKey)new SdfPrivateKey(privateKeyIndex, privateKeyPassword.getBytes()), batcInnerEcRequest.getEncode(), EccCurveTypeEnum.NIST_P_256);
        BATCInnerEcRequestSignedForPop signedForPop = new BATCInnerEcRequestSignedForPop();
        signedForPop.setPayload(securedMessage.getPayload());
        signedForPop.setVersion(securedMessage.getVersion());
        batcitsDataContent.setEnrolmentRequest(signedForPop);
        return batcitsDataContent;
    }

    public static BATCEnrollmentCertResponseData buildECApplyReponse(byte[] requestHashBytes, Enumerated.Value value, PrivateKey ecaPrivateKey, Certificate ecaCert, Certificate ecCert) throws Exception {
        BATCEnrollmentCertResponseData enrollmentCertResponseData = new BATCEnrollmentCertResponseData();
        BATCITSDataContent batcitsDataContent = new BATCITSDataContent();
        BATCInnerEcResponse batcInnerEcResponse = new BATCInnerEcResponse();
        BATCEnrolmentResponseCode batcEnrolmentResponseCode = new BATCEnrolmentResponseCode(value);
        OctetString octetString = new OctetString();
        octetString.setLength(16);
        octetString.setString(requestHashBytes);
        batcInnerEcResponse.setRequestHash(octetString);
        batcInnerEcResponse.setResponseCode(batcEnrolmentResponseCode);
        if (ecCert != null) {
            batcInnerEcResponse.setEcCert(ecCert);
        }
        batcitsDataContent.setEnrolmentResponse(batcInnerEcResponse);
        SecuredMessage securedMessage = SecuredMessageBuilder.buildSignedDataSecuredMessage(new ItsAidInt(623L), ecaPrivateKey, ecaCert, batcitsDataContent.getEncode());
        enrollmentCertResponseData.setPayload(securedMessage.getPayload());
        enrollmentCertResponseData.setVersion(securedMessage.getVersion());
        return enrollmentCertResponseData;
    }
}

