/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.batc;

import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.asn1.batc.BATCResponseCodeEnum;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BATCEnrolmentResponseCode
extends Enumerated {
    private static Logger logger = LoggerFactory.getLogger(BATCEnrolmentResponseCode.class);
    public static final Enumerated.Value OK = new Enumerated.Value(0, "ok");
    public static final Enumerated.Value CANT_PRASE = new Enumerated.Value(1, "cantparse");
    public static final Enumerated.Value BAD_CONTENTTYPE = new Enumerated.Value(2, "badcontenttype");
    public static final Enumerated.Value IMONTTHERE_CIPIENT = new Enumerated.Value(3, "imnottherecipient");
    public static final Enumerated.Value UNKNOW_ENCRYPTION_ALGORITHM = new Enumerated.Value(4, "unknownencryptionalgorithm");
    public static final Enumerated.Value DECRYPTION_FAILED = new Enumerated.Value(5, "decryptionfailed");
    public static final Enumerated.Value UNKNOWN_ITS = new Enumerated.Value(6, "unknownits");
    public static final Enumerated.Value INVALID_SIGNATURE = new Enumerated.Value(7, "invalidsignature");
    public static final Enumerated.Value INCALID_ENTCRYPTIONKEY = new Enumerated.Value(8, "invalidencryptionkey");
    public static final Enumerated.Value BAD_ITS_STATUS = new Enumerated.Value(9, "baditsstatus");
    public static final Enumerated.Value INCOMPLETE_REQUEST = new Enumerated.Value(10, "incompleterequest");
    public static final Enumerated.Value DENIED_PERMISSIONS = new Enumerated.Value(11, "deniedpermissions");
    public static final Enumerated.Value IN_VALIDKEYS = new Enumerated.Value(12, "invalidkeys");
    public static final Enumerated.Value DENIED_REQUEST = new Enumerated.Value(13, "deniedrequest");

    public BATCEnrolmentResponseCode(Enumerated.Value value) {
        super(value);
        this.addValueToList(OK);
        this.addValueToList(CANT_PRASE);
        this.addValueToList(BAD_CONTENTTYPE);
        this.addValueToList(IMONTTHERE_CIPIENT);
        this.addValueToList(UNKNOW_ENCRYPTION_ALGORITHM);
        this.addValueToList(DECRYPTION_FAILED);
        this.addValueToList(UNKNOWN_ITS);
        this.addValueToList(INVALID_SIGNATURE);
        this.addValueToList(INCALID_ENTCRYPTIONKEY);
        this.addValueToList(BAD_ITS_STATUS);
        this.addValueToList(INCOMPLETE_REQUEST);
        this.addValueToList(DENIED_PERMISSIONS);
        this.addValueToList(IN_VALIDKEYS);
        this.addValueToList(DENIED_REQUEST);
    }

    public static BATCEnrolmentResponseCode getInstance(byte[] data) throws Exception {
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        Enumerated.Value value = BATCResponseCodeEnum.EnrolmentResponseCode.getValue(choice.intValue());
        BATCEnrolmentResponseCode responseCode = new BATCEnrolmentResponseCode(value);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        responseCode.setGoal(goal);
        return responseCode;
    }
}

