/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.batc;

import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.batc.BATCEcSignature;
import com.xdja.pki.itsca.oer.asn1.batc.BATCPublicKeys;
import com.xdja.pki.itsca.oer.asn1.batc.BATCSharedAtRequest;
import java.util.Vector;

public class BATCInnerAtRequest
extends Sequence {
    private BATCPublicKeys publicKeys;
    private OctetString hmacKey;
    private HashAlgorithm hashAlg;
    private BATCSharedAtRequest sharedAtRequest;
    private BATCEcSignature ecSignature;

    public BATCInnerAtRequest() {
        super(false, false);
    }

    public static BATCInnerAtRequest getInstance(byte[] data) throws Exception {
        BATCPublicKeys publicKeys = BATCPublicKeys.getInstance(data);
        data = publicKeys.getGoal();
        OctetString hmacKey = OctetString.getInstance(data, 32);
        data = hmacKey.getGoal();
        HashAlgorithm hashAlgorithm = HashAlgorithm.getInstance(data);
        data = hashAlgorithm.getGoal();
        BATCSharedAtRequest sharedAtRequest = BATCSharedAtRequest.getInstance(data);
        data = sharedAtRequest.getGoal();
        BATCEcSignature ecSignature = BATCEcSignature.getInstance(data);
        data = ecSignature.getGoal();
        BATCInnerAtRequest request = new BATCInnerAtRequest();
        request.setPublicKeys(publicKeys);
        request.setHmacKey(hmacKey);
        request.setHashAlg(hashAlgorithm);
        request.setSharedAtRequest(sharedAtRequest);
        request.setEcSignature(ecSignature);
        request.setGoal(data);
        return request;
    }

    public BATCPublicKeys getPublicKeys() {
        return this.publicKeys;
    }

    public void setPublicKeys(BATCPublicKeys publicKeys) {
        this.publicKeys = publicKeys;
    }

    public OctetString getHmacKey() {
        return this.hmacKey;
    }

    public void setHmacKey(OctetString hmacKey) {
        this.hmacKey = hmacKey;
    }

    public HashAlgorithm getHashAlg() {
        return this.hashAlg;
    }

    public void setHashAlg(HashAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public BATCSharedAtRequest getSharedAtRequest() {
        return this.sharedAtRequest;
    }

    public void setSharedAtRequest(BATCSharedAtRequest sharedAtRequest) {
        this.sharedAtRequest = sharedAtRequest;
    }

    public BATCEcSignature getEcSignature() {
        return this.ecSignature;
    }

    public void setEcSignature(BATCEcSignature ecSignature) {
        this.ecSignature = ecSignature;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.publicKeys);
        vector.add(this.hmacKey);
        vector.add(this.hashAlg);
        vector.add(this.sharedAtRequest);
        vector.add(this.ecSignature);
        return vector;
    }
}

