/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.batc;

import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.batc.BATCCertificateFormat;
import com.xdja.pki.itsca.oer.asn1.batc.BATCCertificateSubjectAttributes;
import com.xdja.pki.itsca.oer.asn1.batc.BATCPublicKeys;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class BATCInnerEcRequest
extends Sequence {
    private OctetString itsId;
    private BATCCertificateFormat certificateFormat;
    private BATCPublicKeys publicKeys;
    private BATCCertificateSubjectAttributes requestedSubjectAttributes;

    public static BATCInnerEcRequest getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCInnerEcRequest innerEcRequest = new BATCInnerEcRequest();
        OctetString itsId = OctetString.getInstance(data);
        data = itsId.getGoal();
        BATCCertificateFormat certificateFormat = BATCCertificateFormat.getInstance(data);
        data = certificateFormat.getGoal();
        BATCPublicKeys publicKeys = BATCPublicKeys.getInstance(data);
        data = publicKeys.getGoal();
        BATCCertificateSubjectAttributes requestedSubjectAttributes = BATCCertificateSubjectAttributes.getInstance(data);
        data = requestedSubjectAttributes.getGoal();
        innerEcRequest.setItsId(itsId);
        innerEcRequest.setCertificateFormat(certificateFormat);
        innerEcRequest.setPublicKeys(publicKeys);
        innerEcRequest.setRequestedSubjectAttributes(requestedSubjectAttributes);
        innerEcRequest.setGoal(data);
        return innerEcRequest;
    }

    public BATCInnerEcRequest() {
        super(true, false);
    }

    public OctetString getItsId() {
        return this.itsId;
    }

    public void setItsId(OctetString itsId) {
        this.itsId = itsId;
    }

    public BATCCertificateFormat getCertificateFormat() {
        return this.certificateFormat;
    }

    public void setCertificateFormat(BATCCertificateFormat certificateFormat) {
        this.certificateFormat = certificateFormat;
    }

    public BATCPublicKeys getPublicKeys() {
        return this.publicKeys;
    }

    public void setPublicKeys(BATCPublicKeys publicKeys) {
        this.publicKeys = publicKeys;
    }

    public BATCCertificateSubjectAttributes getRequestedSubjectAttributes() {
        return this.requestedSubjectAttributes;
    }

    public void setRequestedSubjectAttributes(BATCCertificateSubjectAttributes requestedSubjectAttributes) {
        this.requestedSubjectAttributes = requestedSubjectAttributes;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.itsId);
        vector.add(this.certificateFormat);
        vector.add(this.publicKeys);
        vector.add(this.requestedSubjectAttributes);
        return vector;
    }
}

