/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.batc;

import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.batc.BATCEnrolmentResponseCode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class BATCInnerEcResponse
extends Sequence {
    private OctetString requestHash;
    private BATCEnrolmentResponseCode responseCode;
    private Certificate ecCert;

    public BATCInnerEcResponse() {
        super(true, true);
    }

    public static BATCInnerEcResponse getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCInnerEcResponse innerEcResponse = new BATCInnerEcResponse();
        OctetString requestHash = OctetString.getInstance(data, 16);
        data = requestHash.getGoal();
        BATCEnrolmentResponseCode responseCode = BATCEnrolmentResponseCode.getInstance(data);
        data = responseCode.getGoal();
        if (integers.contains(0)) {
            // empty if block
        }
        if (integers.contains(1)) {
            Certificate ecCert = Certificate.getInstance(data);
            data = ecCert.getGoal();
            innerEcResponse.setEcCert(ecCert);
        }
        innerEcResponse.setRequestHash(requestHash);
        innerEcResponse.setResponseCode(responseCode);
        innerEcResponse.setGoal(data);
        return innerEcResponse;
    }

    public OctetString getRequestHash() {
        return this.requestHash;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public BATCEnrolmentResponseCode getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(BATCEnrolmentResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public Certificate getEcCert() {
        return this.ecCert;
    }

    public void setEcCert(Certificate ecCert) {
        this.ecCert = ecCert;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (this.ecCert != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.requestHash);
        vector.add(this.responseCode);
        vector.add(this.ecCert);
        return vector;
    }
}

