/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.batc;

import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.batc.BATCCertificateFormat;
import com.xdja.pki.itsca.oer.asn1.batc.BATCCertificateSubjectAttributes;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class BATCSharedAtRequest
extends Sequence {
    private HashedId8 eaId;
    private OctetString keyTag;
    private BATCCertificateFormat certificateFormat;
    private BATCCertificateSubjectAttributes requestedSubjectAttributes;

    public BATCSharedAtRequest() {
        super(true, false);
    }

    public static BATCSharedAtRequest getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        if (integers.contains(0)) {
            // empty if block
        }
        BATCSharedAtRequest sharedAtRequest = new BATCSharedAtRequest();
        HashedId8 eaId = HashedId8.getInstance(data);
        data = eaId.getGoal();
        OctetString keyTag = OctetString.getInstance(data, 16);
        data = keyTag.getGoal();
        BATCCertificateFormat batcCertificateFormat = BATCCertificateFormat.getInstance(data);
        data = batcCertificateFormat.getGoal();
        BATCCertificateSubjectAttributes requestedSubjectAttributes = BATCCertificateSubjectAttributes.getInstance(data);
        data = requestedSubjectAttributes.getGoal();
        sharedAtRequest.setEaId(eaId);
        sharedAtRequest.setKeyTag(keyTag);
        sharedAtRequest.setCertificateFormat(batcCertificateFormat);
        sharedAtRequest.setRequestedSubjectAttributes(requestedSubjectAttributes);
        sharedAtRequest.setGoal(data);
        return sharedAtRequest;
    }

    public HashedId8 getEaId() {
        return this.eaId;
    }

    public void setEaId(HashedId8 eaId) {
        this.eaId = eaId;
    }

    public OctetString getKeyTag() {
        return this.keyTag;
    }

    public void setKeyTag(OctetString keyTag) {
        this.keyTag = keyTag;
    }

    public BATCCertificateFormat getCertificateFormat() {
        return this.certificateFormat;
    }

    public void setCertificateFormat(BATCCertificateFormat certificateFormat) {
        this.certificateFormat = certificateFormat;
    }

    public BATCCertificateSubjectAttributes getRequestedSubjectAttributes() {
        return this.requestedSubjectAttributes;
    }

    public void setRequestedSubjectAttributes(BATCCertificateSubjectAttributes requestedSubjectAttributes) {
        this.requestedSubjectAttributes = requestedSubjectAttributes;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.eaId);
        vector.add(this.keyTag);
        vector.add(this.certificateFormat);
        vector.add(this.requestedSubjectAttributes);
        return vector;
    }
}

