/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.scms.lccf;

import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.base.Uint16;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class CompositeVersion
extends Sequence {
    private Uint16 gccfVersion;
    private Uint16 lccfVersion;

    public CompositeVersion(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public CompositeVersion() {
        super(false, false);
    }

    public Uint16 getGccfVersion() {
        return this.gccfVersion;
    }

    public void setGccfVersion(Uint16 gccfVersion) {
        this.gccfVersion = gccfVersion;
    }

    public Uint16 getLccfVersion() {
        return this.lccfVersion;
    }

    public void setLccfVersion(Uint16 lccfVersion) {
        this.lccfVersion = lccfVersion;
    }

    public static CompositeVersion getInstance(byte[] data) throws Exception {
        CompositeVersion compositeVersion = new CompositeVersion();
        byte[] gccfVersionBytes = new byte[2];
        System.arraycopy(data, 0, gccfVersionBytes, 0, gccfVersionBytes.length);
        compositeVersion.setGccfVersion(new Uint16(BigIntegers.fromUnsignedByteArray((byte[])gccfVersionBytes).intValue()));
        byte[] lccfVersionBytes = new byte[2];
        System.arraycopy(data, 2, lccfVersionBytes, 0, lccfVersionBytes.length);
        compositeVersion.setLccfVersion(new Uint16(BigIntegers.fromUnsignedByteArray((byte[])lccfVersionBytes).intValue()));
        byte[] goal = new byte[data.length - 4];
        System.arraycopy(data, 4, goal, 0, goal.length);
        compositeVersion.setGoal(goal);
        return compositeVersion;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<Uint16> vector = new Vector<Uint16>();
        vector.add(this.gccfVersion);
        vector.add(this.lccfVersion);
        return vector;
    }
}

