/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.app.SignatureBuild;
import com.xdja.pki.itsca.oer.asn1.CRL;
import com.xdja.pki.itsca.oer.asn1.CertificateDigest;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId10;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.IssuerId;
import com.xdja.pki.itsca.oer.asn1.RevokeInfo;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRevokeInfo;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.ToBeSignedCrl;
import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.asn1.base.Uint32;
import com.xdja.pki.itsca.oer.cert.bean.OERRevokeInfo;
import com.xdja.pki.itsca.oer.enums.CertHashTypeEnum;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CRLBuilder {
    public CRL build(PrivateKey privateKey, long serial, byte[] issuedHash, List<byte[]> hashedId10s) throws Exception {
        ArrayList<OERRevokeInfo> oerRevokeInfos = new ArrayList<OERRevokeInfo>();
        for (int i = 0; i < hashedId10s.size(); ++i) {
            OERRevokeInfo oerRevokeInfo = new OERRevokeInfo();
            oerRevokeInfo.setExpireDate(new Date());
            oerRevokeInfo.setAlgorithm(CertHashTypeEnum.SGD_SM3);
            oerRevokeInfo.setIssueHashId10s(hashedId10s.get(i));
            oerRevokeInfos.add(oerRevokeInfo);
        }
        return this.build(privateKey, serial, oerRevokeInfos, issuedHash, new Date());
    }

    public CRL build(PrivateKey privateKey, long serial, List<OERRevokeInfo> oerRevokeInfos, byte[] issuedHash) throws Exception {
        return this.build(privateKey, serial, oerRevokeInfos, issuedHash, new Date());
    }

    public CRL build(PrivateKey privateKey, long serial, List<OERRevokeInfo> oerRevokeInfos, byte[] issuedHash, Date nexCrl) throws Exception {
        CRL crl = new CRL();
        IssuerId issuerId = new IssuerId();
        CertificateDigest certificateDigest = new CertificateDigest();
        HashAlgorithm hashAlgorithm = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        certificateDigest.setHashAlgorithm(hashAlgorithm);
        byte[] hashId8 = ByteArrayUtils.subByteHashId(issuedHash, 8);
        HashedId8 hashedId8 = new HashedId8(hashId8);
        certificateDigest.setHashedId8(hashedId8);
        issuerId.setCertificateDigest(certificateDigest);
        crl.setIssuerId(issuerId);
        ToBeSignedCrl toBeSignedCrl = new ToBeSignedCrl();
        Uint32 crlSerial = new Uint32(serial);
        long nowTime = TimeUtils.getNowTime();
        Time32 issueDate = new Time32(nowTime);
        long nextTime = TimeUtils.getTimeFromDate(nexCrl);
        Time32 nextCrl = new Time32(nextTime);
        SequenceOfRevokeInfo sequenceOfRevokeInfo = new SequenceOfRevokeInfo();
        for (OERRevokeInfo oerRevokeInfo : oerRevokeInfos) {
            RevokeInfo revokeInfo = new RevokeInfo();
            HashAlgorithm rh = new HashAlgorithm(new Enumerated.Value(oerRevokeInfo.getAlgorithm().id, oerRevokeInfo.getAlgorithm().value));
            HashedId10 id = new HashedId10(oerRevokeInfo.getIssueHashId10s());
            revokeInfo.setHashAlgorithm(rh);
            revokeInfo.setHashedId10(id);
            revokeInfo.setExpiry(new Time32(TimeUtils.getTimeFromDate(oerRevokeInfo.getExpireDate())));
            sequenceOfRevokeInfo.addRevokeInfo(revokeInfo);
        }
        toBeSignedCrl.setCrlSerial(crlSerial);
        toBeSignedCrl.setIssueDate(issueDate);
        toBeSignedCrl.setNextCrl(nextCrl);
        toBeSignedCrl.setEntries(sequenceOfRevokeInfo);
        crl.setToBeSignedCrl(toBeSignedCrl);
        byte[] tbsHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])toBeSignedCrl.getEncode());
        byte[] hash = ByteArrayUtils.buildUpByte(tbsHash, issuedHash);
        Signature signature = SignatureBuild.build(privateKey, hash);
        crl.setSignature(signature);
        return crl;
    }
}

