/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.CertRequest;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.cert.EccPointHolder;
import com.xdja.pki.itsca.oer.cert.TbsCertHolder;
import com.xdja.pki.itsca.oer.cert.bean.OERCertRequest;
import com.xdja.pki.itsca.oer.cert.bean.OEREccPoint;
import com.xdja.pki.itsca.oer.cert.bean.OERTbsCert;
import com.xdja.pki.itsca.oer.enums.GeographicRegionTypeEnum;

public class CertRequestHolder {
    public static OERCertRequest build(byte[] data) throws Exception {
        CertRequest instance = CertRequest.getInstance(data);
        TbsCert tbsCertData = instance.getTbsCertData();
        OERTbsCert tbsCert = TbsCertHolder.build(tbsCertData.getEncode());
        OERCertRequest certRequest = new OERCertRequest();
        try {
            PublicEncryptionKey encryptionKey = instance.getEncryptionKey();
            OEREccPoint eccPoint = EccPointHolder.build(encryptionKey.getPublicKey().getEncode());
            certRequest.setSnapPublic(eccPoint.getPublicKey());
            certRequest.setSnapEccPointType(eccPoint.getEccPointType());
            certRequest.setSnapPublicKeyStr(eccPoint.getPublicKeyStr());
        }
        catch (Exception exception) {
            // empty catch block
        }
        certRequest.setStartTime(tbsCert.getStartTime());
        certRequest.setEndTime(tbsCert.getEndTime());
        certRequest.setSubjectName(tbsCert.getSubjectName());
        certRequest.setSubjectType(tbsCert.getSubjectType());
        certRequest.setSignPublicKey(tbsCert.getSignPublicKey());
        certRequest.setEncPublicKey(tbsCert.getEncPublic());
        certRequest.setItsAid(tbsCert.getItsAid());
        certRequest.setType(tbsCert.getType());
        if (tbsCert.getRegionType().id == GeographicRegionTypeEnum.CIRCULAR_REGION.id) {
            certRequest.setCircularRegion(tbsCert.getCircularRegion());
        }
        if (tbsCert.getRegionType().id == GeographicRegionTypeEnum.RECTANGULAR_REGION.id) {
            certRequest.setRectangularRegions(tbsCert.getRectangularRegions());
        }
        if (tbsCert.getRegionType().id == GeographicRegionTypeEnum.POLYGONAL_REGION.id) {
            certRequest.setPolygonalRegions(tbsCert.getPolygonalRegions());
        }
        certRequest.setItsAid(tbsCert.getItsAid());
        certRequest.setItsAidSspList(tbsCert.getItsAidSspList());
        certRequest.setRegionType(tbsCert.getRegionType());
        certRequest.setStartDate(tbsCert.getStartDate());
        certRequest.setEndDate(tbsCert.getEndDate());
        certRequest.setSignPublicKeyStr(tbsCert.getSignPublicKeyStr());
        certRequest.setSignEccPointType(tbsCert.getSignEccPointType());
        certRequest.setEncPublicKeyStr(tbsCert.getEncPublicKeyStr());
        certRequest.setEncEccPointType(tbsCert.getEncEccPointType());
        return certRequest;
    }
}

