/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.app.SignatureBuild;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.CertificateDigest;
import com.xdja.pki.itsca.oer.asn1.GeographicRegion;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.IssuerId;
import com.xdja.pki.itsca.oer.asn1.RectangularRegion;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidList;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidSspList;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRectangularRegion;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.cert.RectangularRegionBuilder;
import com.xdja.pki.itsca.oer.cert.TbsCertBuilder;
import com.xdja.pki.itsca.oer.enums.CertHashTypeEnum;
import com.xdja.pki.itsca.oer.enums.EccCurveTypeEnum;
import com.xdja.pki.itsca.oer.enums.EccPointTypeEnum;
import com.xdja.pki.itsca.oer.enums.SubjectTypeEnum;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateBuilder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SequenceOfItsAidList itsAidList;
    private SequenceOfItsAidSspList itsAidSspList;
    private GeographicRegion geographicRegion;
    private Time32 startTime;
    private Time32 endTime;
    private EccPointTypeEnum signKeyEccPointType = EccPointTypeEnum.UNCOMPRESSED;
    private EccPointTypeEnum encKeyEccPointType = EccPointTypeEnum.UNCOMPRESSED;
    private EccCurveTypeEnum eccCurveTypeEnum;

    public void setSignKeyEccPointType(EccPointTypeEnum signKeyEccPointType) {
        this.signKeyEccPointType = signKeyEccPointType;
    }

    public void setEncKeyEccPointType(EccPointTypeEnum encKeyEccPointType) {
        this.encKeyEccPointType = encKeyEccPointType;
    }

    public void setEccCurveTypeEnum(EccCurveTypeEnum eccCurveTypeEnum) {
        this.eccCurveTypeEnum = eccCurveTypeEnum;
    }

    public void setStartTime(Time32 startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Time32 endTime) {
        this.endTime = endTime;
    }

    public void setItsAidList(SequenceOfItsAidList itsAidList) {
        this.itsAidList = itsAidList;
    }

    public void setItsAidSspList(SequenceOfItsAidSspList itsAidSspList) {
        this.itsAidSspList = itsAidSspList;
    }

    public void setGeographicRegion(GeographicRegion geographicRegion) {
        this.geographicRegion = geographicRegion;
    }

    public void setGeographicRegion(int northWestLatitude, int northWestLongitude, int southEastLatitude, int southEastLongitude) {
        this.geographicRegion = new GeographicRegion();
        SequenceOfRectangularRegion sequenceOfRectangularRegion = new SequenceOfRectangularRegion();
        RectangularRegionBuilder rectangularRegionBuilder = new RectangularRegionBuilder();
        RectangularRegion rectangularRegion = rectangularRegionBuilder.build(northWestLatitude, northWestLongitude, southEastLatitude, southEastLongitude);
        sequenceOfRectangularRegion.addRectangularRegion(rectangularRegion);
        this.geographicRegion.setRectangularRegion(sequenceOfRectangularRegion);
    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, String subjectName, byte[] issuedHashId, SubjectTypeEnum subjectType) throws Exception {
        return this.build(privateKey, verifyPublicKey, encPublicKey, subjectName.getBytes(), CertHashTypeEnum.SGD_SM3, issuedHashId, subjectType);
    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, byte[] subjectName, byte[] issuedHashId, SubjectTypeEnum subjectType) throws Exception {
        return this.build(privateKey, verifyPublicKey, encPublicKey, subjectName, CertHashTypeEnum.SGD_SM3, issuedHashId, subjectType);
    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, String subjectName, CertHashTypeEnum hashType, byte[] issuedHashId, SubjectTypeEnum subjectType) throws Exception {
        return this.build(privateKey, verifyPublicKey, encPublicKey, subjectName.getBytes(), hashType, issuedHashId, subjectType);
    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, byte[] subjectName, CertHashTypeEnum hashType, byte[] issuedHashId, SubjectTypeEnum subjectType) throws Exception {
        TbsCertBuilder tbsCertBuilder = new TbsCertBuilder();
        if (null != this.endTime) {
            tbsCertBuilder.setEndTime(this.endTime);
        }
        if (null != this.startTime) {
            tbsCertBuilder.setStartTime(this.startTime);
        }
        if (this.itsAidList != null) {
            tbsCertBuilder.setItsAidList(this.itsAidList);
        }
        if (this.itsAidSspList != null) {
            tbsCertBuilder.setItsAidSspList(this.itsAidSspList);
        }
        if (this.geographicRegion != null) {
            tbsCertBuilder.setGeographicRegion(this.geographicRegion);
        }
        tbsCertBuilder.setSignKeyEccPointType(this.signKeyEccPointType);
        tbsCertBuilder.setEncKeyEccPointType(this.encKeyEccPointType);
        tbsCertBuilder.setEccCurveTypeEnum(this.eccCurveTypeEnum);
        TbsCert tbsCert = tbsCertBuilder.build(verifyPublicKey, encPublicKey, subjectName, subjectType);
        return this.build(privateKey, hashType, issuedHashId, tbsCert);
    }

    public Certificate build(PrivateKey privateKey, CertHashTypeEnum hashType, byte[] issueHash, TbsCert tbsCert) throws Exception {
        Certificate certificate = new Certificate();
        IssuerId issuerId = new IssuerId();
        if (issueHash != null) {
            byte[] hashId;
            CertificateDigest certificateDigest = new CertificateDigest();
            HashAlgorithm hashAlgorithm = hashType.id == CertHashTypeEnum.SGD_SM3.id ? new HashAlgorithm(HashAlgorithm.SGD_SM3) : new HashAlgorithm(HashAlgorithm.SHA_256);
            certificateDigest.setHashAlgorithm(hashAlgorithm);
            try {
                hashId = ByteArrayUtils.subByteHashId(issueHash, 8);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            HashedId8 hashedId8 = new HashedId8(hashId);
            certificateDigest.setHashedId8(hashedId8);
            issuerId.setCertificateDigest(certificateDigest);
        } else {
            Null aNull = new Null();
            issuerId.setSelf(aNull);
        }
        certificate.setIssuerId(issuerId);
        certificate.setTbsCert(tbsCert);
        byte[] tbsEncode = tbsCert.getEncode();
        byte[] data = issueHash != null ? (hashType == CertHashTypeEnum.SGD_SM3 ? ByteArrayUtils.buildUpByte(GMSSLSM3DigestUtils.digestByYunhsm((byte[])tbsEncode), issueHash) : ByteArrayUtils.buildUpByte(GMSSLSHA256DigestUtils.digestByBC((byte[])tbsEncode), issueHash)) : (hashType == CertHashTypeEnum.SGD_SM3 ? ByteArrayUtils.buildUpByte(GMSSLSM3DigestUtils.digestByYunhsm((byte[])tbsEncode), GMSSLSM3DigestUtils.digestByYunhsm((byte[])"".getBytes())) : ByteArrayUtils.buildUpByte(GMSSLSHA256DigestUtils.digestByBC((byte[])tbsEncode), GMSSLSHA256DigestUtils.digestByBC((byte[])"".getBytes())));
        Signature signature = SignatureBuild.build(privateKey, data, this.eccCurveTypeEnum);
        certificate.setSignature(signature);
        return certificate;
    }
}

