/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.cert.TbsCertHolder;
import com.xdja.pki.itsca.oer.cert.bean.OERCertificate;
import com.xdja.pki.itsca.oer.cert.bean.OERTbsCert;
import com.xdja.pki.itsca.oer.enums.CertHashTypeEnum;
import com.xdja.pki.itsca.oer.enums.GeographicRegionTypeEnum;
import com.xdja.pki.itsca.oer.enums.IssueIdTypeEnum;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class CertificateHolder {
    public static OERCertificate build(byte[] data) throws Exception {
        byte[] selfHash;
        Certificate certificate = Certificate.getInstance(data);
        OERCertificate oerCertificate = new OERCertificate();
        int version = certificate.getVersion();
        TbsCert tbs = certificate.getTbsCert();
        OERTbsCert tbsCert = TbsCertHolder.build(tbs.getEncode());
        String signerHashId8 = "";
        byte[] encode = certificate.getIssuerId().getEncode();
        if (BigIntegers.fromUnsignedByteArray((byte[])encode, (int)0, (int)1).intValue() == 128) {
            BCECPublicKey publicKey = (BCECPublicKey)tbsCert.getSignPublicKey();
            selfHash = publicKey.getParameters().getCurve() instanceof SM2P256V1Curve ? GMSSLSM3DigestUtils.digestByBC((byte[])certificate.getEncode()) : GMSSLSHA256DigestUtils.digestByBC((byte[])certificate.getEncode());
            oerCertificate.setIssueIdType(IssueIdTypeEnum.NULL);
            byte[] goal = new byte[8];
            System.arraycopy(selfHash, selfHash.length - 8, goal, 0, goal.length);
            oerCertificate.setSignerHashId8(Hex.toHexString((byte[])goal));
        } else {
            HashedId8 hashedId8 = certificate.getIssuerId().getCertificateDigest().getHashedId8();
            signerHashId8 = ByteArrayUtils.hexEncode(hashedId8.getString());
            oerCertificate.setIssueIdType(IssueIdTypeEnum.CERTIFICATE_DIGEST);
            byte[] hashAlg = certificate.getIssuerId().getCertificateDigest().getHashAlgorithm().getEncode();
            BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])hashAlg, (int)0, (int)1);
            if (choice.intValue() == 0) {
                oerCertificate.setIssueIdAlg(CertHashTypeEnum.SGD_SM3);
                selfHash = GMSSLSM3DigestUtils.digestByBC((byte[])certificate.getEncode());
            } else if (choice.intValue() == 1) {
                oerCertificate.setIssueIdAlg(CertHashTypeEnum.SHA_256);
                selfHash = GMSSLSHA256DigestUtils.digestByBC((byte[])certificate.getEncode());
            } else {
                throw new Exception("unsupported HashAlgorithm type" + choice.intValue());
            }
            oerCertificate.setSignerHashId8(signerHashId8);
        }
        byte[] hashid8 = new byte[8];
        System.arraycopy(selfHash, selfHash.length - 8, hashid8, 0, hashid8.length);
        byte[] hashId10 = new byte[10];
        System.arraycopy(selfHash, selfHash.length - 10, hashId10, 0, hashId10.length);
        oerCertificate.setSelfHashId10(Hex.toHexString((byte[])hashId10));
        oerCertificate.setSelfHashId8(Hex.toHexString((byte[])hashid8));
        byte[] r = certificate.getSignature().getR().getxOnly().getString();
        byte[] s = certificate.getSignature().getS().getString();
        byte[] signature = BCUtils.sm2SignDerEncode(r, s);
        oerCertificate.setVersion(version);
        oerCertificate.setTbsCert(tbs);
        oerCertificate.setSubjectName(tbsCert.getSubjectName());
        oerCertificate.setSignPublicKey(tbsCert.getSignPublicKey());
        oerCertificate.setEncPublicKey(tbsCert.getEncPublic());
        oerCertificate.setSubjectType(tbsCert.getSubjectType());
        oerCertificate.setSignature(signature);
        oerCertificate.setStartTime(tbsCert.getStartTime());
        oerCertificate.setEndTime(tbsCert.getEndTime());
        oerCertificate.setType(tbsCert.getType());
        if (tbsCert.getRegionType().id == GeographicRegionTypeEnum.CIRCULAR_REGION.id) {
            oerCertificate.setCircularRegion(tbsCert.getCircularRegion());
        }
        if (tbsCert.getRegionType().id == GeographicRegionTypeEnum.RECTANGULAR_REGION.id) {
            oerCertificate.setRectangularRegions(tbsCert.getRectangularRegions());
        }
        if (tbsCert.getRegionType().id == GeographicRegionTypeEnum.POLYGONAL_REGION.id) {
            oerCertificate.setPolygonalRegions(tbsCert.getPolygonalRegions());
        }
        oerCertificate.setItsAid(tbsCert.getItsAid());
        oerCertificate.setItsAidSspList(tbsCert.getItsAidSspList());
        oerCertificate.setRegionType(tbsCert.getRegionType());
        oerCertificate.setStartDate(tbsCert.getStartDate());
        oerCertificate.setEndDate(tbsCert.getEndDate());
        oerCertificate.setSignPublicKeyStr(tbsCert.getSignPublicKeyStr());
        oerCertificate.setSignEccPointType(tbsCert.getSignEccPointType());
        oerCertificate.setEncPublicKeyStr(tbsCert.getEncPublicKeyStr());
        oerCertificate.setEncEccPointType(tbsCert.getEncEccPointType());
        oerCertificate.setContent(Hex.toHexString((byte[])data));
        return oerCertificate;
    }
}

