/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.Uncompressed;
import com.xdja.pki.itsca.oer.cert.bean.OEREccPoint;
import com.xdja.pki.itsca.oer.enums.EccCurveTypeEnum;
import com.xdja.pki.itsca.oer.enums.EccPointTypeEnum;
import com.xdja.pki.itsca.oer.utils.X509Utils;
import java.math.BigInteger;
import java.security.PublicKey;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EccPointHolder {
    private static Logger logger = LoggerFactory.getLogger(EccPointHolder.class);

    public static OEREccPoint build(byte[] data) throws Exception {
        return EccPointHolder.build(data, EccCurveTypeEnum.SGD_SM2);
    }

    public static OEREccPoint build(byte[] data, EccCurve eccCurve) throws Exception {
        if (eccCurve.readValue().getIndex() == EccCurve.BRAINPOOL_P_256_R1.getIndex()) {
            return EccPointHolder.build(data, EccCurveTypeEnum.BRAINPOOL_P_256_R1);
        }
        if (eccCurve.readValue().getIndex() == EccCurve.NIST_P_256.getIndex()) {
            return EccPointHolder.build(data, EccCurveTypeEnum.NIST_P_256);
        }
        return EccPointHolder.build(data, EccCurveTypeEnum.SGD_SM2);
    }

    public static OEREccPoint build(byte[] data, EccCurveTypeEnum curveTypeEnum) throws Exception {
        EccPoint eccPoint = EccPoint.getInstance(data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        OEREccPoint oerEccPoint = new OEREccPoint();
        if (choice.intValue() - 128 == 0) {
            logger.debug("EccPoint choice xOnly");
        } else if (choice.intValue() - 128 == 1) {
            logger.debug("EccPoint choice fill");
        } else {
            if (choice.intValue() - 128 == 2) {
                logger.debug("EccPoint choice compressedY0");
                oerEccPoint.setEccPointType(EccPointTypeEnum.COMPRESSED_Y0);
                oerEccPoint.setPublicKey(X509Utils.decodePoint(false, eccPoint.getCompressedY0().getString(), curveTypeEnum));
                oerEccPoint.setPublicKeyStr(Hex.toHexString((byte[])eccPoint.getCompressedY0().getString()));
                return oerEccPoint;
            }
            if (choice.intValue() - 128 == 3) {
                logger.debug("EccPoint choice compressedY1");
                oerEccPoint.setEccPointType(EccPointTypeEnum.COMPRESSED_Y1);
                oerEccPoint.setPublicKey(X509Utils.decodePoint(true, eccPoint.getCompressedY1().getString(), curveTypeEnum));
                oerEccPoint.setPublicKeyStr(Hex.toHexString((byte[])eccPoint.getCompressedY1().getString()));
                return oerEccPoint;
            }
            if (choice.intValue() - 128 == 4) {
                logger.debug("EccPoint choice Uncompressed");
                oerEccPoint.setEccPointType(EccPointTypeEnum.UNCOMPRESSED);
                oerEccPoint.setPublicKey(EccPointHolder.getUncompressed(eccPoint.getUncompressed(), curveTypeEnum));
                oerEccPoint.setPublicKeyStr(Hex.toHexString((byte[])eccPoint.getUncompressed().getEncode()));
                return oerEccPoint;
            }
            logger.error("EccPoint choice is error " + choice.intValue());
            throw new Exception("unsupported this eccpoint type id =  " + choice.intValue());
        }
        return null;
    }

    private static PublicKey getUncompressed(Uncompressed uncompressed, EccCurveTypeEnum curveTypeEnum) throws Exception {
        byte[] x = uncompressed.getX().getString();
        byte[] y = uncompressed.getY().getString();
        if (curveTypeEnum == EccCurveTypeEnum.SGD_SM2) {
            return X509Utils.convertSM2PublicKey(x, y);
        }
        if (curveTypeEnum == EccCurveTypeEnum.NIST_P_256) {
            return X509Utils.convertNISTPPublicKey(BigIntegers.fromUnsignedByteArray((byte[])x), BigIntegers.fromUnsignedByteArray((byte[])y));
        }
        return X509Utils.convertBRAINPOOLPublicKey(BigIntegers.fromUnsignedByteArray((byte[])x), BigIntegers.fromUnsignedByteArray((byte[])y));
    }
}

