/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.GeographicRegion;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.PublicVerifyKey;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidList;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidSspList;
import com.xdja.pki.itsca.oer.asn1.SubjectAttribute;
import com.xdja.pki.itsca.oer.asn1.SubjectInfo;
import com.xdja.pki.itsca.oer.asn1.SubjectType;
import com.xdja.pki.itsca.oer.asn1.SymmetricAlgorithm;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.TimeStartAndEnd;
import com.xdja.pki.itsca.oer.asn1.ValidityPeriod;
import com.xdja.pki.itsca.oer.asn1.ValidityRestriction;
import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.cert.EccPointBuilder;
import com.xdja.pki.itsca.oer.enums.EccCurveTypeEnum;
import com.xdja.pki.itsca.oer.enums.EccPointTypeEnum;
import com.xdja.pki.itsca.oer.enums.SubjectTypeEnum;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Curve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TbsCertBuilder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SequenceOfItsAidList itsAidList;
    private SequenceOfItsAidSspList itsAidSspList;
    private GeographicRegion geographicRegion;
    private Time32 startTime;
    private Time32 endTime;
    private EccPointTypeEnum signKeyEccPointType = EccPointTypeEnum.UNCOMPRESSED;
    private EccPointTypeEnum encKeyEccPointType = EccPointTypeEnum.UNCOMPRESSED;
    private EccCurveTypeEnum eccCurveTypeEnum;

    public void setSignKeyEccPointType(EccPointTypeEnum signKeyEccPointType) {
        this.signKeyEccPointType = signKeyEccPointType;
    }

    public void setEncKeyEccPointType(EccPointTypeEnum encKeyEccPointType) {
        this.encKeyEccPointType = encKeyEccPointType;
    }

    public void setStartTime(Time32 startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Time32 endTime) {
        this.endTime = endTime;
    }

    public void setItsAidList(SequenceOfItsAidList itsAidList) {
        this.itsAidList = itsAidList;
    }

    public void setItsAidSspList(SequenceOfItsAidSspList itsAidSspList) {
        this.itsAidSspList = itsAidSspList;
    }

    public void setGeographicRegion(GeographicRegion geographicRegion) {
        this.geographicRegion = geographicRegion;
    }

    public void setEccCurveTypeEnum(EccCurveTypeEnum eccCurveTypeEnum) {
        this.eccCurveTypeEnum = eccCurveTypeEnum;
    }

    public TbsCert build(PublicKey verifyPublicKey, PublicKey encPublicKey, String subjectName, SubjectTypeEnum subjectType) throws Exception {
        return this.build(verifyPublicKey, encPublicKey, subjectName.getBytes(), subjectType);
    }

    public TbsCert build(PublicKey verifyPublicKey, PublicKey encPublicKey, byte[] subjectName, SubjectTypeEnum subjectType) throws Exception {
        TbsCert tbsCert = new TbsCert();
        this.buildSubjectInfo(tbsCert, subjectName, subjectType);
        this.buildSubjectAttribute(tbsCert, verifyPublicKey, encPublicKey);
        this.buildValidityRestriction(tbsCert);
        return tbsCert;
    }

    public void buildSubjectInfo(TbsCert tbsCert, String subjectName, SubjectTypeEnum subjectType) throws IOException {
        this.buildSubjectInfo(tbsCert, subjectName.getBytes(), subjectType);
    }

    public void buildSubjectInfo(TbsCert tbsCert, byte[] subjectName, SubjectTypeEnum subjectType) throws IOException {
        SubjectInfo subjectInfo = new SubjectInfo();
        SubjectType certType = new SubjectType(new Enumerated.Value(subjectType.id, subjectType.value));
        subjectInfo.setSubjectType(certType);
        subjectInfo.setSubjectName(subjectName);
        tbsCert.setSubjectInfo(subjectInfo);
    }

    public void buildSubjectAttribute(TbsCert tbsCert, PublicKey verifyPublicKey, PublicKey encPublicKey) throws Exception {
        SubjectAttribute subjectAttribute = new SubjectAttribute();
        PublicVerifyKey verifyKey = new PublicVerifyKey();
        if (null == this.eccCurveTypeEnum) {
            BCECPublicKey signKey = (BCECPublicKey)verifyPublicKey;
            this.eccCurveTypeEnum = signKey.getParameters().getCurve() instanceof SM2P256V1Curve ? EccCurveTypeEnum.SGD_SM2 : (signKey.getParameters().getCurve() instanceof SecP256R1Curve ? EccCurveTypeEnum.NIST_P_256 : EccCurveTypeEnum.BRAINPOOL_P_256_R1);
        }
        EccCurve eccCurve = new EccCurve(new Enumerated.Value(this.eccCurveTypeEnum.id, this.eccCurveTypeEnum.value));
        verifyKey.setEccCurve(eccCurve);
        EccPoint signEcc = EccPointBuilder.build(verifyPublicKey, this.signKeyEccPointType);
        verifyKey.setEccPoint(signEcc);
        subjectAttribute.setVerifyKey(verifyKey);
        if (null != encPublicKey) {
            PublicEncryptionKey encryptionKey = new PublicEncryptionKey();
            if (this.eccCurveTypeEnum == EccCurveTypeEnum.SGD_SM2) {
                encryptionKey.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_ECB));
            } else {
                encryptionKey.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.AES_128_CCM));
            }
            encryptionKey.setEccCurve(new EccCurve(new Enumerated.Value(this.eccCurveTypeEnum.id, this.eccCurveTypeEnum.value)));
            EccPoint encEcc = EccPointBuilder.build(encPublicKey, this.encKeyEccPointType);
            encryptionKey.setPublicKey(encEcc);
            subjectAttribute.setEncryptionKey(encryptionKey);
        }
        if (this.itsAidList != null) {
            subjectAttribute.setItsAidList(this.itsAidList);
        }
        if (this.itsAidSspList != null) {
            subjectAttribute.setItsSspList(this.itsAidSspList);
        }
        tbsCert.setSubjectAttribute(subjectAttribute);
    }

    public void buildValidityRestriction(TbsCert tbsCert) throws IOException {
        ValidityRestriction validityRestriction = new ValidityRestriction();
        ValidityPeriod validityPeriod = new ValidityPeriod();
        TimeStartAndEnd startAndEnd = new TimeStartAndEnd();
        if (null == this.endTime) {
            long nowTime = TimeUtils.getNowTime();
            Time32 time32 = new Time32(nowTime);
            startAndEnd.setStartValidity(time32);
            long timeEnd = TimeUtils.getTimeAfterYear(1);
            time32 = new Time32(timeEnd);
            startAndEnd.setEndValidity(time32);
            validityPeriod.setTimeStartAndEnd(startAndEnd);
        } else if (null == this.startTime) {
            validityPeriod.setTimeEnd(this.endTime);
        } else {
            startAndEnd = new TimeStartAndEnd();
            startAndEnd.setStartValidity(this.startTime);
            startAndEnd.setEndValidity(this.endTime);
            validityPeriod.setTimeStartAndEnd(startAndEnd);
        }
        validityRestriction.setValidityPeriod(validityPeriod);
        if (this.geographicRegion != null) {
            validityRestriction.setGeographicRegion(this.geographicRegion);
        }
        tbsCert.setValidityRestriction(validityRestriction);
    }
}

