/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.utils;

import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.X509Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class BCUtils {
    private static final String SM4_ALGORITHM = "SM4";

    public static byte[] generateRandomByBC(int len) throws NoSuchAlgorithmException {
        return Hex.decode((String)"0123456789abcdeffedcba9876543210");
    }

    public static KeyPair generateSM2KeyPairByBC() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return X509Utils.generateSM2KeyPair();
    }

    public static String sm2EncryptByBC(PublicKey publicKey, String base64Data) throws CryptoException, IOException {
        byte[] data = ByteArrayUtils.base64Decode(base64Data);
        AsymmetricKeyParameter keyParameter = X509Utils.convertECPublicKeyParameters(publicKey);
        byte[] cipher = BCUtils.sm2EncryptByBC((ECKeyParameters)keyParameter, new SecureRandom(), data, 0, data.length);
        return ByteArrayUtils.base64Encode(cipher);
    }

    public static String sm2DecryptByBC(PrivateKey privateKey, String base64Data) throws IOException, InvalidCipherTextException {
        AsymmetricKeyParameter keyParameter = X509Utils.convertECPrivateKeyKeyParameters(privateKey);
        byte[] data = ByteArrayUtils.base64Decode(base64Data);
        byte[] out = BCUtils.sm2DecryptByBC((ECKeyParameters)keyParameter, data, 0, data.length);
        return ByteArrayUtils.base64Encode(out);
    }

    public static byte[] sm2DecryptByBC(PrivateKey privateKey, byte[] data) throws IOException, InvalidCipherTextException {
        AsymmetricKeyParameter keyParameter = X509Utils.convertECPrivateKeyKeyParameters(privateKey);
        return BCUtils.sm2DecryptByBC((ECKeyParameters)keyParameter, data, 0, data.length);
    }

    public static String sm2EncryptASN1ByBC(PublicKey publicKey, String base64Data) throws CryptoException, IOException {
        byte[] data = ByteArrayUtils.base64Decode(base64Data);
        byte[] cipher = BCUtils.sm2EncryptASN1ByBC(publicKey, data);
        return ByteArrayUtils.base64Encode(cipher);
    }

    public static byte[] sm2EncryptASN1ByBC(PublicKey publicKey, byte[] data) throws CryptoException, IOException {
        AsymmetricKeyParameter keyParameter = X509Utils.convertECPublicKeyParameters(publicKey);
        byte[] cipher = BCUtils.sm2EncryptASN1ByBC((ECKeyParameters)keyParameter, new SecureRandom(), data, 0, data.length);
        return cipher;
    }

    public static String sm2DecryptASN1ByBC(PrivateKey privateKey, String base64Data) throws IOException, InvalidCipherTextException {
        byte[] data = ByteArrayUtils.base64Decode(base64Data);
        byte[] out = BCUtils.sm2DecryptASN1ByBC(privateKey, data);
        return ByteArrayUtils.base64Encode(out);
    }

    public static byte[] sm2DecryptASN1ByBC(PrivateKey privateKey, byte[] data) throws IOException, InvalidCipherTextException {
        AsymmetricKeyParameter keyParameter = X509Utils.convertECPrivateKeyKeyParameters(privateKey);
        byte[] out = BCUtils.sm2DecryptASN1ByBC((ECKeyParameters)keyParameter, data, 0, data.length);
        return out;
    }

    public static byte[] sm2EncryptByBC(ECKeyParameters keyParameter, SecureRandom secureRandom, byte[] input, int inOff, int length) throws InvalidCipherTextException {
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParameter, secureRandom));
        return sm2Engine.processBlock(input, inOff, length);
    }

    public static byte[] sm2DecryptByBC(ECKeyParameters keyParameter, byte[] input, int inOff, int length) throws InvalidCipherTextException {
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)keyParameter);
        return sm2Engine.processBlock(input, inOff, length);
    }

    public static byte[] sm2EncryptASN1ByBC(ECKeyParameters keyParameter, SecureRandom secureRandom, byte[] input, int inOff, int length) throws InvalidCipherTextException, IOException {
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParameter, secureRandom));
        byte[] ciphertext = sm2Engine.processBlock(input, inOff, length);
        ECCurve curve = keyParameter.getParameters().getCurve();
        int curveLength = (curve.getFieldSize() + 7) / 8;
        byte[] c1 = new byte[curveLength * 2 + 1];
        System.arraycopy(ciphertext, inOff, c1, 0, c1.length);
        ECPoint c1P = curve.decodePoint(c1);
        byte[] xb = c1P.getXCoord().getEncoded();
        byte[] yb = c1P.getYCoord().getEncoded();
        SM3Digest digest = new SM3Digest();
        byte[] c2 = new byte[length];
        System.arraycopy(ciphertext, ciphertext.length - length - digest.getDigestSize(), c2, 0, length);
        byte[] c3 = new byte[digest.getDigestSize()];
        System.arraycopy(ciphertext, ciphertext.length - digest.getDigestSize(), c3, 0, digest.getDigestSize());
        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(xb, yb, c3, c2);
        byte[] result = asn1SM2Cipher.toASN1Primitive().getEncoded();
        return result;
    }

    public static byte[] sm2DecryptASN1ByBC(ECKeyParameters keyParameter, byte[] input) throws InvalidCipherTextException {
        return BCUtils.sm2DecryptASN1ByBC(keyParameter, input, 0, input.length);
    }

    public static byte[] sm2DecryptASN1ByBC(ECKeyParameters keyParameter, byte[] input, int inOff, int length) throws InvalidCipherTextException {
        byte[] sm2CipherASN1 = new byte[length];
        System.arraycopy(input, inOff, sm2CipherASN1, 0, length);
        ASN1SM2Cipher asn1 = ASN1SM2Cipher.getInstance((Object)sm2CipherASN1);
        ECCurve curve = keyParameter.getParameters().getCurve();
        BigInteger x = asn1.getxCoordinate();
        BigInteger y = asn1.getyCoordinate();
        ECPoint point = curve.createPoint(x, y);
        byte[] c1 = point.getEncoded(false);
        byte[] c2 = asn1.getCipherText();
        byte[] c3 = asn1.getHash();
        byte[] ciphertext = Arrays.concatenate((byte[])c1, (byte[])c2, (byte[])c3);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)keyParameter);
        byte[] M = sm2Engine.processBlock(ciphertext, 0, ciphertext.length);
        return M;
    }

    public static String sm2SignByBC(PrivateKey privateKey, String base64Data) throws CryptoException, IOException {
        byte[] data = ByteArrayUtils.base64Decode(base64Data);
        byte[] sig = BCUtils.sm2SignByBC(privateKey, data);
        return ByteArrayUtils.base64Encode(sig);
    }

    public static byte[] sm2SignByBC(PrivateKey privateKey, byte[] data) throws CryptoException, IOException {
        AsymmetricKeyParameter keyParameter = X509Utils.convertECPrivateKeyKeyParameters(privateKey);
        SM2Signer signer = new SM2Signer();
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)keyParameter, new SecureRandom());
        ParametersWithID parametersWithID = new ParametersWithID((CipherParameters)parametersWithRandom, "China".getBytes());
        signer.init(true, (CipherParameters)parametersWithID);
        signer.update(data, 0, data.length);
        return signer.generateSignature();
    }

    public static byte[][] sm2SignDerDecode(byte[] sign) throws IOException {
        ASN1Sequence var2 = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])sign));
        if (var2.size() != 2) {
            return null;
        }
        BigInteger var3 = ASN1Integer.getInstance((Object)var2.getObjectAt(0)).getValue();
        BigInteger var4 = ASN1Integer.getInstance((Object)var2.getObjectAt(1)).getValue();
        return new byte[][]{ByteArrayUtils.changeByteArrayLength(var3), ByteArrayUtils.changeByteArrayLength(var4)};
    }

    public static byte[] sm2SignDerEncode(byte[] r, byte[] s) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(BigIntegers.fromUnsignedByteArray((byte[])r)));
        v.add((ASN1Encodable)new ASN1Integer(BigIntegers.fromUnsignedByteArray((byte[])s)));
        return new DERSequence(v).getEncoded("DER");
    }

    public static boolean sm2VerifyByBC(PublicKey publicKey, String base64Data, String base64Sign) throws IOException {
        byte[] data = ByteArrayUtils.base64Decode(base64Data);
        byte[] sign = ByteArrayUtils.base64Decode(base64Sign);
        return BCUtils.sm2VerifyByBC(publicKey, data, sign);
    }

    public static boolean sm2VerifyByBC(PublicKey publicKey, byte[] data, byte[] sign) throws IOException {
        AsymmetricKeyParameter keyParameter = X509Utils.convertECPublicKeyParameters(publicKey);
        SM2Signer signer = new SM2Signer();
        ParametersWithID parametersWithID = new ParametersWithID((CipherParameters)keyParameter, "China".getBytes());
        signer.init(false, (CipherParameters)parametersWithID);
        signer.update(data, 0, data.length);
        return signer.verifySignature(sign);
    }

    public static String sm3DigestByBC(String base64Data) {
        byte[] data = ByteArrayUtils.base64Decode(base64Data);
        byte[] digest = BCUtils.sm3DigestByBC(data);
        return ByteArrayUtils.base64Encode(digest);
    }

    public static byte[] sm3DigestByBC(byte[] data) {
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(data, 0, data.length);
        byte[] out = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(out, 0);
        return out;
    }

    public static String sm3DigestByBCWithPublicKey(ECPublicKey publicKey, String base64Data) {
        byte[] data = ByteArrayUtils.base64Decode(base64Data);
        byte[] digest = BCUtils.sm3DigestByBCWithPublicKey(publicKey, data);
        return ByteArrayUtils.base64Encode(digest);
    }

    public static byte[] sm3DigestByBCWithPublicKey(ECPublicKey publicKey, byte[] data) {
        SM3Digest digest = new SM3Digest();
        byte[] userID = ByteArrayUtils.hexDecode("31323334353637383132333435363738");
        byte[] x = publicKey.getW().getAffineX().toByteArray();
        byte[] y = publicKey.getW().getAffineY().toByteArray();
        int len = userID.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userID, 0, userID.length);
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)"sm2p256v1");
        ECCurve curve = ecParameterSpec.getCurve();
        ECPoint G = ecParameterSpec.getG();
        BCUtils.addFieldElement((Digest)digest, curve.getA().toBigInteger());
        BCUtils.addFieldElement((Digest)digest, curve.getB().toBigInteger());
        BCUtils.addFieldElement((Digest)digest, G.getAffineXCoord().toBigInteger());
        BCUtils.addFieldElement((Digest)digest, G.getAffineYCoord().toBigInteger());
        BCUtils.addFieldElement((Digest)digest, BigIntegers.fromUnsignedByteArray((byte[])x));
        BCUtils.addFieldElement((Digest)digest, BigIntegers.fromUnsignedByteArray((byte[])y));
        byte[] z = new byte[digest.getDigestSize()];
        digest.doFinal(z, 0);
        digest.update(z, 0, z.length);
        digest.update(data, 0, data.length);
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        return out;
    }

    private static void addFieldElement(Digest digest, BigInteger p) {
        byte[] in = ByteArrayUtils.asUnsignedByteArray32(p);
        digest.update(in, 0, in.length);
    }

    public static String sm4EncryptByBCWithNoPadding(String base64Key, String base64Data) throws Exception {
        return ByteArrayUtils.base64Encode(BCUtils.symmetricECBEncryptByBC(true, EncryptTypeByBC.SM4_ECB_NoPadding, ByteArrayUtils.base64Decode(base64Key), ByteArrayUtils.base64Decode(base64Data)));
    }

    public static String sm4EncryptByBCWithPKCS5Padding(String base64Key, String base64Data) throws Exception {
        return ByteArrayUtils.base64Encode(BCUtils.symmetricECBEncryptByBC(true, EncryptTypeByBC.SM4_ECB_PKCS5Padding, ByteArrayUtils.base64Decode(base64Key), ByteArrayUtils.base64Decode(base64Data)));
    }

    public static String sm4EncryptByBCWithPKCS7Padding(String base64Key, String base64Data) throws Exception {
        return ByteArrayUtils.base64Encode(BCUtils.symmetricECBEncryptByBC(true, EncryptTypeByBC.SM4_ECB_PKCS7Padding, ByteArrayUtils.base64Decode(base64Key), ByteArrayUtils.base64Decode(base64Data)));
    }

    public static String sm4DecryptByBCWithNoPadding(String base64Key, String base64Data) throws Exception {
        return ByteArrayUtils.base64Encode(BCUtils.symmetricECBEncryptByBC(false, EncryptTypeByBC.SM4_ECB_NoPadding, ByteArrayUtils.base64Decode(base64Key), ByteArrayUtils.base64Decode(base64Data)));
    }

    public static String sm4DecryptByBCWithPKCS5Padding(String base64Key, String base64Data) throws Exception {
        return ByteArrayUtils.base64Encode(BCUtils.symmetricECBEncryptByBC(false, EncryptTypeByBC.SM4_ECB_PKCS5Padding, ByteArrayUtils.base64Decode(base64Key), ByteArrayUtils.base64Decode(base64Data)));
    }

    public static String sm4DecryptByBCWithPKCS7Padding(String base64Key, String base64Data) throws Exception {
        return ByteArrayUtils.base64Encode(BCUtils.symmetricECBEncryptByBC(false, EncryptTypeByBC.SM4_ECB_PKCS7Padding, ByteArrayUtils.base64Decode(base64Key), ByteArrayUtils.base64Decode(base64Data)));
    }

    public static byte[] symmetricECBEncryptByBC(boolean forEncryption, EncryptTypeByBC encryptType, byte[] key, byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(encryptType.getName(), "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key, SM4_ALGORITHM);
        if (forEncryption) {
            cipher.init(1, keySpec);
        } else {
            cipher.init(2, keySpec);
        }
        return cipher.doFinal(data);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static enum EncryptTypeByBC {
        SM4_ECB_NoPadding("SM4/ECB/NoPadding"),
        SM4_ECB_PKCS5Padding("SM4/ECB/PKCS5Padding"),
        SM4_ECB_PKCS7Padding("SM4/ECB/PKCS7Padding"),
        SM4_CBC_NoPadding("SM4/CBC/NoPadding"),
        SM4_CBC_PKCS5Padding("SM4/CBC/PKCS5Padding"),
        SM4_CBC_PKCS7Padding("SM4/CBC/PKCS7Padding");

        private String name;

        private EncryptTypeByBC(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

