/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLBCCipherUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.itsca.oer.utils.X509Utils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Curve;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.util.BitArray;

public class ButterFlyKeyUtils {
    private static Logger logger;

    public static ECPublicKey expansionFunction(ECPublicKey A, int i, int j, byte[] aesKey, boolean isEnc) throws Exception {
        byte[] xFirst = ButterFlyKeyUtils.fillBitByte(32, isEnc);
        byte[] xEnd = ButterFlyKeyUtils.fillBitByte(32, false);
        byte[] x = ButterFlyKeyUtils.iota(xFirst, i, j, xEnd);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"x", (byte[])x);
        BigInteger N = A.getParameters().getN();
        BigInteger function = ButterFlyKeyUtils.function(x, aesKey, N);
        return ButterFlyKeyUtils.addExpansionEcPoint(A, function);
    }

    public static ECPrivateKey expansionFunction(ECPrivateKey a, int i, int j, byte[] aesKey, boolean isEnc) throws Exception {
        byte[] xFirst = ButterFlyKeyUtils.fillBitByte(32, isEnc);
        byte[] xEnd = ButterFlyKeyUtils.fillBitByte(32, false);
        byte[] x = ButterFlyKeyUtils.iota(xFirst, i, j, xEnd);
        BigInteger N = a.getParameters().getN();
        BigInteger function = ButterFlyKeyUtils.function(x, aesKey, N);
        BigInteger b = function.add(a.getD()).mod(N);
        ECCurve curve = a.getParameters().getCurve();
        return ButterFlyKeyUtils.generateECPrivateWithBigInteger(curve, b);
    }

    public static ECPrivateKey generateECPrivateWithBigInteger(ECCurve curve, BigInteger b) throws Exception {
        if (curve instanceof SecP256R1Curve) {
            return (ECPrivateKey)X509Utils.convertNISTPPrivateKey(b);
        }
        if (curve instanceof SM2P256V1Curve) {
            return (ECPrivateKey)X509Utils.convertSM2PrivateKey(b);
        }
        return null;
    }

    public static ECPublicKey addExpansionEcPoint(ECPublicKey A, BigInteger function) throws Exception {
        ECPoint G = A.getParameters().getG();
        ECPoint Function2 = G.multiply(function);
        ECPoint B = ButterFlyKeyUtils.addECPoint(Function2, A.getQ());
        ECCurve curve = A.getParameters().getCurve();
        return ButterFlyKeyUtils.generateECPublicWithECPoint(curve, B);
    }

    public static ECPublicKey generateECPublicWithECPoint(ECCurve curve, ECPoint B) throws Exception {
        if (curve instanceof SecP256R1Curve) {
            return (ECPublicKey)X509Utils.convertNISTPPublicKey(B.getAffineXCoord().toBigInteger(), B.getAffineYCoord().toBigInteger());
        }
        if (curve instanceof SM2P256V1Curve) {
            return (ECPublicKey)GMSSLX509Utils.convertSM2PublicKey((BigInteger)B.getAffineXCoord().toBigInteger(), (BigInteger)B.getAffineYCoord().toBigInteger());
        }
        return null;
    }

    private static BigInteger function(byte[] x, byte[] aesKey, BigInteger N) throws Exception {
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"x", (byte[])x);
        byte[] x1 = ButterFlyKeyUtils.add(x, 1);
        byte[] x2 = ButterFlyKeyUtils.add(x, 2);
        byte[] x3 = ButterFlyKeyUtils.add(x, 3);
        byte[] aseX1 = ButterFlyKeyUtils.aesEncrypt(aesKey, x1);
        byte[] aseX2 = ButterFlyKeyUtils.aesEncrypt(aesKey, x2);
        byte[] aseX3 = ButterFlyKeyUtils.aesEncrypt(aesKey, x3);
        byte[] xor1 = ButterFlyKeyUtils.xor(aseX1, x1);
        byte[] xor2 = ButterFlyKeyUtils.xor(aseX2, x2);
        byte[] xor3 = ButterFlyKeyUtils.xor(aseX3, x3);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"xor1", (byte[])xor1);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"xor2", (byte[])xor2);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"xor3", (byte[])xor3);
        byte[] makeUp = ButterFlyKeyUtils.sortAndMakeUp(xor1, xor2, xor3);
        byte[] function = ButterFlyKeyUtils.mod(makeUp, N);
        return BigIntegers.fromUnsignedByteArray((byte[])function);
    }

    private static byte[] sortAndMakeUp(byte[] xor1, byte[] xor2, byte[] xor3) {
        ArrayList<BigInteger> list = new ArrayList<BigInteger>();
        list.add(BigIntegers.fromUnsignedByteArray((byte[])xor1));
        list.add(BigIntegers.fromUnsignedByteArray((byte[])xor2));
        list.add(BigIntegers.fromUnsignedByteArray((byte[])xor3));
        byte[] x = BigIntegers.asUnsignedByteArray((int)16, (BigInteger)((BigInteger)list.get(0)));
        byte[] y = BigIntegers.asUnsignedByteArray((int)16, (BigInteger)((BigInteger)list.get(1)));
        byte[] z = BigIntegers.asUnsignedByteArray((int)16, (BigInteger)((BigInteger)list.get(2)));
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"list.get(0)", (byte[])x);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"list.get(1)", (byte[])y);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"list.get(2)", (byte[])z);
        return ButterFlyKeyUtils.functionInt(x, y, z);
    }

    private static byte[] uint32(int i) {
        return ByteBuffer.allocate(4).putInt(i).array();
    }

    public static byte[] mod(byte[] fint, BigInteger N) {
        BigInteger f = BigIntegers.fromUnsignedByteArray((byte[])fint);
        return BigIntegers.asUnsignedByteArray((BigInteger)f.mod(N));
    }

    public static ECPoint addECPoint(ECPoint P, ECPoint F) {
        return P.add(F).getDetachedPoint();
    }

    private static byte[] xor(byte[] a, byte[] b) {
        BigInteger aInt = BigIntegers.fromUnsignedByteArray((byte[])a);
        BigInteger bInt = BigIntegers.fromUnsignedByteArray((byte[])b);
        BigInteger xor = aInt.xor(bInt);
        return BigIntegers.asUnsignedByteArray((int)16, (BigInteger)xor);
    }

    private static byte[] aesEncrypt(byte[] k, byte[] data) throws Exception {
        return GMSSLBCCipherUtils.symmetricECBEncrypt((String)"SM4/ECB/NoPadding", (byte[])k, (byte[])data);
    }

    private static byte[] add(byte[] x, int i) {
        BigInteger result = BigIntegers.fromUnsignedByteArray((byte[])x).add(BigInteger.valueOf(i));
        return BigIntegers.asUnsignedByteArray((int)16, (BigInteger)result);
    }

    private static byte[] functionInt(byte[] first, byte[] second, byte[] third) {
        byte[] result = new byte[first.length + second.length + third.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        System.arraycopy(third, 0, result, first.length + second.length, third.length);
        return result;
    }

    private static byte[] iota(byte[] first, int i, int j, byte[] end) {
        byte[] formatI = ButterFlyKeyUtils.getI(i);
        byte[] formatJ = ButterFlyKeyUtils.getJ(j);
        byte[] result = new byte[first.length + formatI.length + formatJ.length + end.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(formatI, 0, result, first.length, formatI.length);
        System.arraycopy(formatJ, 0, result, first.length + formatI.length, formatJ.length);
        System.arraycopy(end, 0, result, first.length + formatI.length + formatJ.length, end.length);
        return result;
    }

    private static byte[] fillBitByte(int count, boolean value) {
        boolean[] booleans = new boolean[count];
        for (int i = 0; i < booleans.length; ++i) {
            booleans[i] = value;
        }
        BitArray bitArray = new BitArray(booleans);
        return bitArray.toByteArray();
    }

    private static byte[] getI(int k) {
        byte[] i = ButterFlyKeyUtils.uint32(k);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"i", (byte[])i);
        return i;
    }

    private static byte[] getJ(int k) {
        byte[] j = ButterFlyKeyUtils.uint32(k);
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"j", (byte[])j);
        return j;
    }

    public static ECPublicKey addECPublic(ECPublicKey A, ECPublicKey B) throws Exception {
        ECPoint detachedPoint = A.getQ().add(B.getQ()).getDetachedPoint();
        return ButterFlyKeyUtils.generateECPublicWithECPoint(A.getParameters().getCurve(), detachedPoint);
    }

    public static ECPrivateKey addPrivateKey(BigInteger a, ECPrivateKey b) throws Exception {
        BigInteger mod = a.add(b.getD()).mod(b.getParameters().getN());
        return ButterFlyKeyUtils.generateECPrivateWithBigInteger(b.getParameters().getCurve(), mod);
    }

    public static ECPrivateKey addPrivateKey(ECPrivateKey a, ECPrivateKey b) throws Exception {
        BigInteger mod = a.getD().add(b.getD()).mod(b.getParameters().getN());
        return ButterFlyKeyUtils.generateECPrivateWithBigInteger(b.getParameters().getCurve(), mod);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        logger = LoggerFactory.getLogger(ButterFlyKeyUtils.class);
    }
}

