/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.utils;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.utils.ButterFlyKeyUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class ImplicitCertPublicUtils {
    public static BigInteger buildReconstructionValue(Enumerated.Value hashAlgorithm, Certificate caCert, Certificate eeCert, ECPrivateKey s) throws Exception {
        BigInteger N = s.getParameters().getN();
        BigInteger hashBigInter = ImplicitCertPublicUtils.getHashBigInteger(hashAlgorithm, caCert, eeCert, N);
        return s.getD().add(hashBigInter).mod(N);
    }

    public static ECPublicKey buildReconstructionPublicKey(Enumerated.Value hashAlgorithm, Certificate caCert, Certificate eeCert, ECPublicKey S, ECPublicKey B) throws Exception {
        BigInteger N = B.getParameters().getN();
        ECPoint G = B.getParameters().getG();
        BigInteger hashBigInteger = ImplicitCertPublicUtils.getHashBigInteger(hashAlgorithm, caCert, eeCert, N);
        ECPoint hashEcPoint = G.multiply(hashBigInteger);
        ECPoint reconstructionPoint = hashEcPoint.add(S.getQ());
        ECPoint lastPoint = ButterFlyKeyUtils.addECPoint(reconstructionPoint, B.getQ());
        return ButterFlyKeyUtils.generateECPublicWithECPoint(S.getParameters().getCurve(), lastPoint);
    }

    public static ECPrivateKey buildEcPrivateKey(BigInteger reconstructionValue, ECPrivateKey bPrivateKey) throws Exception {
        return ButterFlyKeyUtils.addPrivateKey(reconstructionValue, bPrivateKey);
    }

    private static BigInteger getHashBigInteger(Enumerated.Value hashAlgorithm, Certificate caCert, Certificate eeCert, BigInteger N) throws Exception {
        byte[] hash;
        if (hashAlgorithm == HashAlgorithm.SGD_SM3) {
            byte[] issueCertHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])caCert.getEncode());
            byte[] eeCertHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])eeCert.getEncode());
            hash = ByteArrayUtils.buildUpByte(issueCertHash, eeCertHash);
        } else if (hashAlgorithm == HashAlgorithm.SHA_256) {
            byte[] issueCertHash = GMSSLSHA256DigestUtils.digestByYunHsm((byte[])caCert.getEncode());
            byte[] eeCertHash = GMSSLSHA256DigestUtils.digestByYunHsm((byte[])eeCert.getEncode());
            hash = ByteArrayUtils.buildUpByte(issueCertHash, eeCertHash);
        } else {
            throw new Exception("unknown hashAlgorithm value : " + hashAlgorithm.toString());
        }
        return BigIntegers.fromUnsignedByteArray((byte[])ButterFlyKeyUtils.mod(hash, N));
    }
}

