/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.CertRequest;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.asn1.Uncompressed;
import com.xdja.pki.itsca.oer.cert.OERCertRequest;
import com.xdja.pki.itsca.oer.cert.OERTbsCert;
import com.xdja.pki.itsca.oer.cert.TbsCertHolder;
import com.xdja.pki.itsca.oer.utils.X509Utils;
import java.security.PublicKey;

public class CertRequestHolder {
    public static OERCertRequest build(byte[] data) throws Exception {
        CertRequest instance = CertRequest.getInstance(data);
        TbsCert tbsCertData = instance.getTbsCertData();
        OERTbsCert tbsCert = TbsCertHolder.build(tbsCertData.getEncode());
        PublicEncryptionKey encryptionKey = instance.getEncryptionKey();
        Uncompressed uncompressed = encryptionKey.getPublicKey().getUncompressed();
        byte[] x = uncompressed.getX().getString();
        byte[] y = uncompressed.getY().getString();
        PublicKey publicKey = X509Utils.convertSM2PublicKey(x, y);
        OERCertRequest certRequest = new OERCertRequest();
        certRequest.setSnapPublic(publicKey);
        certRequest.setStartTime(tbsCert.getStartTime());
        certRequest.setEndTime(tbsCert.getEndTime());
        certRequest.setSubjectName(tbsCert.getSubjectName());
        certRequest.setSubjectType(tbsCert.getSubjectType());
        certRequest.setSignPublicKey(tbsCert.getSignPublicKey());
        certRequest.setEncPublicKey(tbsCert.getEncPublic());
        certRequest.setItsAid(tbsCert.getItsAid());
        certRequest.setNorthWestLatitude(tbsCert.getNorthWestLatitude());
        certRequest.setNorthWestLongitude(tbsCert.getNorthWestLongitude());
        certRequest.setSouthEastLatitude(tbsCert.getSouthEastLatitude());
        certRequest.setSouthEastLongitude(tbsCert.getSouthEastLongitude());
        return certRequest;
    }
}

