/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.cert.OERCertificate;
import com.xdja.pki.itsca.oer.cert.OERTbsCert;
import com.xdja.pki.itsca.oer.cert.TbsCertHolder;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;

public class CertificateHolder {
    public static OERCertificate build(byte[] data) throws Exception {
        byte[] goal;
        byte[] bytes;
        Certificate certificate = Certificate.getInstance(data);
        int version = certificate.getVersion();
        TbsCert tbs = certificate.getTbsCert();
        OERTbsCert tbsCert = TbsCertHolder.build(tbs.getEncode());
        String signerHashId8 = "";
        byte[] encode = certificate.getIssuerId().getEncode();
        if (BigIntegers.fromUnsignedByteArray((byte[])encode, (int)0, (int)1).intValue() == 128) {
            bytes = BCUtils.sm3DigestByBC(certificate.getEncode());
            goal = new byte[8];
            System.arraycopy(bytes, bytes.length - 8, goal, 0, goal.length);
            signerHashId8 = ByteArrayUtils.hexEncode(goal);
        } else {
            HashedId8 hashedId8 = certificate.getIssuerId().getCertificateDigest().getHashedId8();
            signerHashId8 = ByteArrayUtils.hexEncode(hashedId8.getString());
        }
        bytes = BCUtils.sm3DigestByBC(certificate.getEncode());
        goal = new byte[8];
        System.arraycopy(bytes, bytes.length - 8, goal, 0, goal.length);
        String selfHashId8 = ByteArrayUtils.hexEncode(goal);
        byte[] r = certificate.getSignature().getR().getxOnly().getString();
        byte[] s = certificate.getSignature().getS().getString();
        byte[] signature = BCUtils.sm2SignDerEncode(r, s);
        OERCertificate oerCertificate = new OERCertificate();
        oerCertificate.setVersion(version);
        oerCertificate.setTbsCert(tbs);
        oerCertificate.setSubjectName(tbsCert.getSubjectName());
        oerCertificate.setSignerHashId8(signerHashId8);
        oerCertificate.setSelfHashId8(selfHashId8);
        oerCertificate.setSignPublicKey(tbsCert.getSignPublicKey());
        oerCertificate.setEncPublicKey(tbsCert.getEncPublic());
        oerCertificate.setSubjectType(tbsCert.getSubjectType());
        oerCertificate.setSignature(signature);
        oerCertificate.setStartTime(tbsCert.getStartTime());
        oerCertificate.setEndTime(tbsCert.getEndTime());
        oerCertificate.setItsAid(tbsCert.getItsAid());
        oerCertificate.setNorthWestLatitude(tbsCert.getNorthWestLatitude());
        oerCertificate.setNorthWestLongitude(tbsCert.getNorthWestLongitude());
        oerCertificate.setSouthEastLatitude(tbsCert.getSouthEastLatitude());
        oerCertificate.setSouthEastLongitude(tbsCert.getSouthEastLongitude());
        return oerCertificate;
    }
}

