/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.app.data.KekBuilder;
import com.xdja.pki.itsca.oer.asn1.CertRequest;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.CipherText;
import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.EciesEncryptedKey;
import com.xdja.pki.itsca.oer.asn1.EncryptedData;
import com.xdja.pki.itsca.oer.asn1.GeographicRegion;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.ItsAid;
import com.xdja.pki.itsca.oer.asn1.Latitude;
import com.xdja.pki.itsca.oer.asn1.Longitude;
import com.xdja.pki.itsca.oer.asn1.PKRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.RecipientInfo;
import com.xdja.pki.itsca.oer.asn1.RectangularRegion;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidList;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRectangularRegion;
import com.xdja.pki.itsca.oer.asn1.SymmetricAlgorithm;
import com.xdja.pki.itsca.oer.asn1.SymmetricCipherText;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.TwoDLocation;
import com.xdja.pki.itsca.oer.asn1.Uncompressed;
import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.cert.TbsCertBuilder;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertDataBuilder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    CertRequest buildCertRequest(PublicKey certPublicKey, PublicKey temporaryPublic, String itsId, String subjectName, Enumerated.Value subjectTypeValue) throws Exception {
        TbsCertBuilder tbsCertBuilder = new TbsCertBuilder();
        SequenceOfItsAidList sequenceOfItsAidList = new SequenceOfItsAidList();
        sequenceOfItsAidList.addItsAid(ItsAid.TRAFFIC_LIGHT_APPLICATION);
        sequenceOfItsAidList.addItsAid(ItsAid.NON_REGISTRATION_CERTIFICATE_REQUEST);
        sequenceOfItsAidList.addItsAid(ItsAid.REGISTRATION_CERTIFICATE_RESPONSE);
        tbsCertBuilder.setItsAidList(sequenceOfItsAidList);
        GeographicRegion geographicRegion = new GeographicRegion();
        SequenceOfRectangularRegion sequenceOfRectangularRegion = new SequenceOfRectangularRegion();
        RectangularRegion rectangularRegion = new RectangularRegion();
        TwoDLocation twoDLocation = new TwoDLocation();
        twoDLocation.setLongitude(new Longitude(57834));
        twoDLocation.setLatitude(new Latitude(4897202));
        rectangularRegion.setSouthEast(twoDLocation);
        twoDLocation.setLongitude(new Longitude(547834));
        twoDLocation.setLatitude(new Latitude(985434));
        rectangularRegion.setNorthWest(twoDLocation);
        sequenceOfRectangularRegion.addRectangularRegion(rectangularRegion);
        geographicRegion.setRectangularRegion(sequenceOfRectangularRegion);
        tbsCertBuilder.setGeographicRegion(geographicRegion);
        TbsCert tbsCert = tbsCertBuilder.build(certPublicKey, certPublicKey, subjectName, subjectTypeValue);
        CertRequest certRequest = new CertRequest();
        OctetString id = new OctetString();
        id.setString(itsId.getBytes());
        byte[] decode = Hex.decode((String)"33303832303331313330383230314639");
        OctetString octetString = new OctetString();
        octetString.setString(decode);
        certRequest.setItsId(decode);
        long nowTime = TimeUtils.getNowTime();
        Time32 currentTime = new Time32(nowTime);
        certRequest.setCurrentTime(currentTime);
        certRequest.setTbsCertData(tbsCert);
        PublicEncryptionKey publicEncryptionKey = new PublicEncryptionKey();
        publicEncryptionKey.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        publicEncryptionKey.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_ECB));
        Uncompressed uncompressed = new Uncompressed();
        ECPublicKey ecPublicKey = (ECPublicKey)temporaryPublic;
        byte[] x = BigIntegers.asUnsignedByteArray((BigInteger)ecPublicKey.getW().getAffineX());
        byte[] y = BigIntegers.asUnsignedByteArray((BigInteger)ecPublicKey.getW().getAffineY());
        uncompressed.setX(x);
        uncompressed.setY(y);
        EccPoint eccPoint = new EccPoint();
        eccPoint.setUncompressed(uncompressed);
        publicEncryptionKey.setPublicKey(eccPoint);
        certRequest.setEncryptionKey(publicEncryptionKey);
        ByteArrayUtils.printHexBinary(null, "certRequest", certRequest.getEncode());
        return certRequest;
    }

    SecuredMessage buildSecuredMessage(CertRequest certRequest, boolean isSignedDataRecip, byte[] key, byte[] data) throws Exception {
        SecuredMessage securedMessage = new SecuredMessage();
        PKRecipientInfo pkRecipientInfo = new PKRecipientInfo();
        HashAlgorithm hashAlg = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        pkRecipientInfo.setHashAlg(hashAlg);
        byte[] certReqHash = BCUtils.sm3DigestByBC(certRequest.getEncode());
        byte[] certHashId8 = new byte[8];
        System.arraycopy(certReqHash, certReqHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        ByteArrayUtils.printHexBinary(null, "hashID data ", certHashId8);
        HashedId8 recipientId = new HashedId8(certHashId8);
        pkRecipientInfo.setRecipientId(recipientId);
        EccPoint publicKey = certRequest.getEncryptionKey().getPublicKey();
        EciesEncryptedKey kek = KekBuilder.build(publicKey, key);
        pkRecipientInfo.setKek(kek);
        EncryptedData encData = new EncryptedData();
        SequenceOfRecipientInfo recipients = new SequenceOfRecipientInfo();
        RecipientInfo recipientInfo = isSignedDataRecip ? new RecipientInfo(pkRecipientInfo, PKRecipientInfoType.SIGNEDDATA_RECIPINFO) : new RecipientInfo(pkRecipientInfo, PKRecipientInfoType.CERT_RECIPINFO);
        recipients.addRecipientInfo(recipientInfo);
        encData.setRecipients(recipients);
        byte[] bytes = BCUtils.symmetricECBEncryptByBC(true, BCUtils.EncryptTypeByBC.SM4_ECB_PKCS7Padding, key, data);
        ByteArrayUtils.printHexBinary(null, "BCUtils bytes", bytes);
        CipherText cipherData = new CipherText();
        cipherData.setString(bytes);
        SymmetricCipherText cipherText = new SymmetricCipherText(cipherData);
        encData.setCipherText(cipherText);
        Payload payload = new Payload(encData);
        securedMessage.setPayload(payload);
        return securedMessage;
    }

    SecuredMessage buildSecuredMessage(Certificate pcaCert, EccPoint publicKey, boolean isSignedDataRecip, byte[] key, byte[] data) throws Exception {
        this.logger.info("buildSecuredMessage         ");
        SecuredMessage securedMessage = new SecuredMessage();
        PKRecipientInfo pkRecipientInfo = new PKRecipientInfo();
        HashAlgorithm hashAlg = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        pkRecipientInfo.setHashAlg(hashAlg);
        this.logger.info("buildSecuredMessage          start get pca cert encode");
        byte[] certReqHash = BCUtils.sm3DigestByBC(pcaCert.getEncode());
        this.logger.info("buildSecuredMessage          done get pca cert encode");
        byte[] certHashId8 = new byte[8];
        System.arraycopy(certReqHash, certReqHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        ByteArrayUtils.printHexBinary(null, "hashID data ", certHashId8);
        HashedId8 recipientId = new HashedId8(certHashId8);
        pkRecipientInfo.setRecipientId(recipientId);
        EciesEncryptedKey kek = KekBuilder.build(publicKey, key);
        pkRecipientInfo.setKek(kek);
        EncryptedData encData = new EncryptedData();
        SequenceOfRecipientInfo recipients = new SequenceOfRecipientInfo();
        RecipientInfo recipientInfo = isSignedDataRecip ? new RecipientInfo(pkRecipientInfo, PKRecipientInfoType.SIGNEDDATA_RECIPINFO) : new RecipientInfo(pkRecipientInfo, PKRecipientInfoType.CERT_RECIPINFO);
        recipients.addRecipientInfo(recipientInfo);
        encData.setRecipients(recipients);
        byte[] bytes = BCUtils.symmetricECBEncryptByBC(true, BCUtils.EncryptTypeByBC.SM4_ECB_PKCS7Padding, key, data);
        ByteArrayUtils.printHexBinary(null, "BCUtils bytes", bytes);
        CipherText cipherData = new CipherText();
        cipherData.setString(bytes);
        SymmetricCipherText cipherText = new SymmetricCipherText(cipherData);
        encData.setCipherText(cipherText);
        Payload payload = new Payload(encData);
        securedMessage.setPayload(payload);
        return securedMessage;
    }
}

