/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.app.SignatureBuild;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.HeaderInfo;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.SequenceOfCertificate;
import com.xdja.pki.itsca.oer.asn1.SharedATRequest;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.SignedData;
import com.xdja.pki.itsca.oer.asn1.SignerInfo;
import com.xdja.pki.itsca.oer.asn1.TBSData;
import com.xdja.pki.itsca.oer.asn1.Time64;
import com.xdja.pki.itsca.oer.asn1.base.Int;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.security.PrivateKey;

public class SignedExternalPayloadBuilder {
    public static SecuredMessage builder(SharedATRequest sharedATRequest, Certificate ecCert, PrivateKey ecPrivateKey) throws Exception {
        SignedData signedData = new SignedData();
        SequenceOfCertificate sequenceOfCertificate = new SequenceOfCertificate();
        sequenceOfCertificate.addCertificate(ecCert);
        SignerInfo signerInfo = new SignerInfo(sequenceOfCertificate);
        signedData.setSignerInfo(signerInfo);
        TBSData tbsData = new TBSData();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setItsAid(new Int(40965L));
        headerInfo.setGenTime(new Time64(TimeUtils.getNowTime()));
        tbsData.setHeaderInfo(headerInfo);
        byte[] bytes = GMSSLSM3DigestUtils.digestByBC((byte[])sharedATRequest.getEncode());
        tbsData.setExtHash(bytes);
        signedData.setTbs(tbsData);
        Signature signature = SignatureBuild.build(ecPrivateKey, tbsData);
        signedData.setSign(signature);
        SecuredMessage securedMessage = new SecuredMessage();
        Payload payload = new Payload(signedData);
        securedMessage.setPayload(payload);
        return securedMessage;
    }
}

