/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredMessage
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SecuredMessage.class);
    private Payload payload;
    private int version;

    public SecuredMessage() {
        super(false, false);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public static SecuredMessage getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "SecuredMessage start data", data);
        SecuredMessage securedMessage = new SecuredMessage();
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        securedMessage.setVersion(integer.intValue());
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        Payload payload = Payload.getInstance(goal);
        securedMessage.setPayload(payload);
        ByteArrayUtils.printHexBinary(logger, "SecuredMessage payload data", payload.getEncode());
        securedMessage.setGoal(payload.getGoal());
        ByteArrayUtils.printHexBinary(logger, "SecuredMessage lave data", securedMessage.getGoal());
        return securedMessage;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(2);
        vector.add(this.payload);
        return vector;
    }
}

